/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.util.Arrays;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class MultiplyWithCarry256
extends IntProvider {
    private static final int Q_SIZE = 256;
    private static final int SEED_SIZE = 257;
    private static final long A = 809430660L;
    private final int[] state = new int[256];
    private int index;
    private int carry;

    public MultiplyWithCarry256(int[] seed) {
        this.setSeedInternal(seed);
    }

    @Override
    protected byte[] getStateInternal() {
        int[] s = Arrays.copyOf(this.state, 258);
        s[256] = this.carry;
        s[257] = this.index;
        return NumberFactory.makeByteArray(s);
    }

    @Override
    protected void setStateInternal(byte[] s) {
        this.checkStateSize(s, 1032);
        int[] tmp = NumberFactory.makeIntArray(s);
        System.arraycopy(tmp, 0, this.state, 0, 256);
        this.carry = tmp[256];
        this.index = tmp[257];
    }

    private void setSeedInternal(int[] seed) {
        int[] tmp = new int[257];
        this.fillState(tmp, seed);
        int c = tmp[0];
        this.carry = (int)((long)(c < 0 ? -c : c) % 809430660L);
        System.arraycopy(tmp, 1, this.state, 0, 256);
        this.index = 256;
    }

    @Override
    public int next() {
        if (this.index == 256) {
            for (int i = 0; i < 256; ++i) {
                long t = 809430660L * ((long)this.state[i] & 0xFFFFFFFFL) + (long)this.carry;
                this.carry = (int)(t >> 32);
                this.state[i] = (int)t;
            }
            this.index = 0;
        }
        return this.state[this.index++];
    }
}

