/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public class TxVerboseId
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private IgniteUuid uuid;
    private GridCacheVersion gridCacheVer;

    public TxVerboseId() {
    }

    public TxVerboseId(IgniteUuid uuid, GridCacheVersion gridCacheVer) {
        this.uuid = uuid;
        this.gridCacheVer = gridCacheVer;
    }

    public static TxVerboseId fromString(String text) {
        try {
            return new TxVerboseId(IgniteUuid.fromString(text), null);
        }
        catch (RuntimeException runtimeException) {
            GridCacheVersion gcv = new GridCacheVersion(0, 0, 0L);
            String regexPtrn = gcv.toString().replaceAll("\\d+", "(\\\\d+)").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]");
            Pattern p = Pattern.compile(regexPtrn);
            Matcher m = p.matcher(text);
            if (!m.find()) {
                throw new IllegalArgumentException("Argument for tx --info should be either UUID or GridCacheVersion text representation: " + text);
            }
            assert (m.groupCount() == 3) : "Unexpected group count [cnt=" + m.groupCount() + ", pattern=" + regexPtrn + ']';
            try {
                return new TxVerboseId(null, new GridCacheVersion(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(3)), Long.parseLong(m.group(2))));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Argument for tx --info should be either UUID or GridCacheVersion text representation: " + text, e);
            }
        }
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeIgniteUuid(out, this.uuid);
        out.writeObject(this.gridCacheVer);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.uuid = U.readIgniteUuid(in);
        this.gridCacheVer = (GridCacheVersion)in.readObject();
    }

    public IgniteUuid uuid() {
        return this.uuid;
    }

    public GridCacheVersion gridCacheVersion() {
        return this.gridCacheVer;
    }

    public String toString() {
        return S.toString(TxVerboseId.class, this);
    }
}

