/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteUuid;

public class GridSetQueryPredicate<K, V>
implements IgniteBiPredicate<K, V>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private IgniteUuid setId;
    private boolean collocated;
    private GridCacheContext ctx;
    private boolean filter;

    public GridSetQueryPredicate() {
    }

    public GridSetQueryPredicate(IgniteUuid setId, boolean collocated) {
        this.setId = setId;
        this.collocated = collocated;
    }

    public void init(GridCacheContext ctx) {
        this.ctx = ctx;
        this.filter = this.filterKeys();
    }

    public boolean collocated() {
        return this.collocated;
    }

    public IgniteUuid setId() {
        return this.setId;
    }

    @Override
    public boolean apply(K k, V v) {
        return !this.filter || this.ctx.affinity().primaryByKey(this.ctx.localNode(), k, this.ctx.affinity().affinityTopologyVersion());
    }

    private boolean filterKeys() {
        return !this.collocated && !this.ctx.isLocal() && !this.ctx.isReplicated() && (CU.isNearEnabled(this.ctx) || this.ctx.isPartitioned());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeIgniteUuid(out, this.setId);
        out.writeBoolean(this.collocated);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setId = U.readIgniteUuid(in);
        this.collocated = in.readBoolean();
    }

    public String toString() {
        return S.toString(GridSetQueryPredicate.class, this);
    }
}

