/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.keys;

import java.util.UUID;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;

public class UuidIndexKey
implements IndexKey {
    private final UUID key;

    public UuidIndexKey(UUID key) {
        this.key = key;
    }

    @Override
    public Object key() {
        return this.key;
    }

    @Override
    public int type() {
        return 20;
    }

    @Override
    public int compare(IndexKey o) {
        UUID okey = (UUID)o.key();
        if (this.key.getMostSignificantBits() == okey.getMostSignificantBits()) {
            return Long.compare(this.key.getLeastSignificantBits(), okey.getLeastSignificantBits());
        }
        return this.key.getMostSignificantBits() > okey.getMostSignificantBits() ? 1 : -1;
    }
}

