/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.StringIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class StringInlineIndexKeyType
extends NullableInlineIndexKeyType<StringIndexKey> {
    protected static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final boolean compareIgnoreCase = false;

    public StringInlineIndexKeyType() {
        super(13, (short)-1);
    }

    @Override
    protected int put0(long pageAddr, int off, StringIndexKey str, int maxSize) {
        byte[] s = ((String)str.key()).getBytes(CHARSET);
        short size = s.length + 3 <= maxSize ? (short)s.length : (short)((s = StringInlineIndexKeyType.trimUTF8(s, maxSize - 3)) == null ? 0 : s.length | 0x8000);
        if (s == null) {
            PageUtils.putByte(pageAddr, off, (byte)-1);
            return 0;
        }
        PageUtils.putByte(pageAddr, off, (byte)this.type());
        PageUtils.putShort(pageAddr, off + 1, size);
        PageUtils.putBytes(pageAddr, off + 3, s);
        return s.length + 3;
    }

    @Override
    @Nullable
    protected StringIndexKey get0(long pageAddr, int off) {
        String s = new String(this.readBytes(pageAddr, off), CHARSET);
        return new StringIndexKey(s);
    }

    @Override
    public int compare0(long pageAddr, int off, StringIndexKey key) {
        int res;
        char v2;
        char v1;
        int c;
        String s = (String)key.key();
        int len1 = PageUtils.getShort(pageAddr, off + 1) & Short.MAX_VALUE;
        int len2 = s.length();
        int cntr1 = 0;
        int cntr2 = 0;
        long addr = pageAddr + (long)off + 3L;
        while (cntr1 < len1 && cntr2 < len2 && (c = GridUnsafe.getByte(addr) & 0xFF) <= 127) {
            ++cntr1;
            ++addr;
            v1 = (char)c;
            if (v1 == (v2 = s.charAt(cntr2++))) continue;
            return Integer.signum(v1 - v2);
        }
        block7: while (cntr1 < len1 && cntr2 < len2) {
            c = GridUnsafe.getByte(addr++) & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++cntr1;
                    v1 = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    int c2;
                    if ((cntr1 += 2) > len1) {
                        throw new IllegalStateException("Malformed input (partial character at the end).");
                    }
                    if (((c2 = GridUnsafe.getByte(addr++) & 0xFF) & 0xC0) != 128) {
                        throw new IllegalStateException("Malformed input around byte: " + (cntr1 - 2));
                    }
                    c &= 0x1F;
                    c = c << 6 | c2 & 0x3F;
                    v1 = (char)c;
                    break;
                }
                case 14: {
                    if ((cntr1 += 3) > len1) {
                        throw new IllegalStateException("Malformed input (partial character at the end).");
                    }
                    int c2 = GridUnsafe.getByte(addr++) & 0xFF;
                    int c3 = GridUnsafe.getByte(addr++) & 0xFF;
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new IllegalStateException("Malformed input around byte: " + (cntr1 - 3));
                    }
                    c &= 0xF;
                    c = c << 6 | c2 & 0x3F;
                    c = c << 6 | c3 & 0x3F;
                    v1 = (char)c;
                    break;
                }
                case 15: {
                    if ((cntr1 += 4) > len1) {
                        throw new IllegalStateException("Malformed input (partial character at the end).");
                    }
                    int c2 = GridUnsafe.getByte(addr++) & 0xFF;
                    int c3 = GridUnsafe.getByte(addr++) & 0xFF;
                    int c4 = GridUnsafe.getByte(addr++) & 0xFF;
                    if ((c & 0xF8) != 240 || (c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128) {
                        throw new IllegalStateException("Malformed input around byte: " + (cntr1 - 4));
                    }
                    c &= 7;
                    c = c << 6 | c2 & 0x3F;
                    c = c << 6 | c3 & 0x3F;
                    c = c << 6 | c4 & 0x3F;
                    v1 = (char)(55296 + ((c -= 65536) >> 10 & 0x7FF));
                    if (v1 != (v2 = s.charAt(cntr2++))) {
                        return Integer.signum(v1 - v2);
                    }
                    if (cntr2 == len2) {
                        return 1;
                    }
                    v1 = (char)(56320 + (c & 0x3FF));
                    if (v1 == (v2 = s.charAt(cntr2++))) continue block7;
                    return Integer.signum(v1 - v2);
                }
                default: {
                    throw new IllegalStateException("Malformed input around byte: " + cntr1);
                }
            }
            if (v1 == (v2 = s.charAt(cntr2++))) continue;
            return Integer.signum(v1 - v2);
        }
        int n = cntr1 == len1 && cntr2 == len2 ? 0 : (res = cntr1 == len1 ? -1 : 1);
        if (this.isValueFull(pageAddr, off)) {
            return res;
        }
        if (res >= 0) {
            return 1;
        }
        return -2;
    }

    public static byte[] trimUTF8(byte[] bytes, int limit) {
        if (bytes.length <= limit) {
            return bytes;
        }
        for (int i = limit; i > 0; --i) {
            if ((bytes[i] & 0xC0) == 128) continue;
            byte[] res = new byte[i];
            System.arraycopy(bytes, 0, res, 0, i);
            return res;
        }
        return null;
    }

    private boolean isValueFull(long pageAddr, int off) {
        return (PageUtils.getShort(pageAddr, off + 1) & 0x8000) == 0;
    }

    @Override
    protected int inlineSize0(StringIndexKey key) {
        return ((String)key.key()).getBytes(CHARSET).length + 3;
    }
}

