/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ignite.internal.binary.BinarySchema;
import org.jetbrains.annotations.Nullable;

public class BinarySchemaRegistry {
    private static final int EMPTY = 0;
    private volatile boolean inline = true;
    private int schemaId1;
    private int schemaId2;
    private int schemaId3;
    private int schemaId4;
    private BinarySchema schema1;
    private BinarySchema schema2;
    private BinarySchema schema3;
    private BinarySchema schema4;
    private volatile HashMap<Integer, BinarySchema> schemas;

    @Nullable
    public BinarySchema schema(int schemaId) {
        if (this.inline) {
            if (schemaId == this.schemaId1) {
                return this.schema1;
            }
            if (schemaId == this.schemaId2) {
                return this.schema2;
            }
            if (schemaId == this.schemaId3) {
                return this.schema3;
            }
            if (schemaId == this.schemaId4) {
                return this.schema4;
            }
        } else {
            HashMap<Integer, BinarySchema> schemas0 = this.schemas;
            if (schemas0 != null) {
                return schemas0.get(schemaId);
            }
        }
        return null;
    }

    public synchronized void addSchema(int schemaId, BinarySchema schema) {
        if (this.inline) {
            if (schemaId == this.schemaId1 || schemaId == this.schemaId2 || schemaId == this.schemaId3 || schemaId == this.schemaId4) {
                return;
            }
            if (this.schemaId1 == 0) {
                this.schemaId1 = schemaId;
                this.schema1 = schema;
                this.inline = true;
                return;
            }
            if (this.schemaId2 == 0) {
                this.schemaId2 = schemaId;
                this.schema2 = schema;
                this.inline = true;
                return;
            }
            if (this.schemaId3 == 0) {
                this.schemaId3 = schemaId;
                this.schema3 = schema;
                this.inline = true;
                return;
            }
            if (this.schemaId4 == 0) {
                this.schemaId4 = schemaId;
                this.schema4 = schema;
                this.inline = true;
                return;
            }
            HashMap<Integer, BinarySchema> newSchemas = new HashMap<Integer, BinarySchema>();
            newSchemas.put(this.schemaId1, this.schema1);
            newSchemas.put(this.schemaId2, this.schema2);
            newSchemas.put(this.schemaId3, this.schema3);
            newSchemas.put(this.schemaId4, this.schema4);
            newSchemas.put(schemaId, schema);
            this.schemas = newSchemas;
            this.inline = false;
        } else {
            HashMap<Integer, BinarySchema> newSchemas = new HashMap<Integer, BinarySchema>(this.schemas);
            newSchemas.put(schemaId, schema);
            this.schemas = newSchemas;
        }
    }

    public synchronized List<BinarySchema> schemas() {
        ArrayList<BinarySchema> res = new ArrayList<BinarySchema>();
        if (this.inline) {
            if (this.schemaId1 != 0) {
                res.add(this.schema1);
            }
            if (this.schemaId2 != 0) {
                res.add(this.schema2);
            }
            if (this.schemaId3 != 0) {
                res.add(this.schema3);
            }
            if (this.schemaId4 != 0) {
                res.add(this.schema4);
            }
        } else {
            res.addAll(this.schemas.values());
        }
        return res;
    }
}

