/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.index.keys;

import org.apache.ignite.internal.cache.query.index.sorted.keys.AbstractTimestampIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.processors.query.h2.index.keys.H2ValueWrapperMixin;
import org.h2.value.Value;
import org.h2.value.ValueTimestamp;

public class TimestampIndexKey
extends AbstractTimestampIndexKey
implements H2ValueWrapperMixin {
    private final ValueTimestamp timestamp;

    public TimestampIndexKey(Object obj) {
        this.timestamp = (ValueTimestamp)this.wrapToValue(obj, this.type());
    }

    public static TimestampIndexKey fromDateValueAndNanos(long dateVal, long nanos) {
        return new TimestampIndexKey(ValueTimestamp.fromDateValueAndNanos((long)dateVal, (long)nanos));
    }

    private TimestampIndexKey(ValueTimestamp timestamp) {
        this.timestamp = timestamp;
    }

    public Object key() {
        return this.timestamp.getTimestamp();
    }

    public long dateValue() {
        return this.timestamp.getDateValue();
    }

    public long nanos() {
        return this.timestamp.getTimeNanos();
    }

    public int compare(IndexKey o) {
        return this.timestamp.compareTo((Value)((TimestampIndexKey)o).timestamp, null);
    }
}

