/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.index;

import java.util.List;
import org.apache.ignite.internal.cache.query.index.IndexName;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowCache;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRowComparator;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandlerFactory;
import org.apache.ignite.internal.cache.query.index.sorted.MetaPageInfo;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.index.H2RowComparator;
import org.apache.ignite.internal.processors.query.h2.index.QueryIndexKeyDefinitionProvider;
import org.apache.ignite.internal.processors.query.h2.index.QueryRowHandlerFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.table.IndexColumn;

public class QueryIndexDefinition
implements SortedIndexDefinition {
    private List<IndexKeyDefinition> keyDefs;
    private List<IndexColumn> h2UnwrappedCols;
    private List<IndexColumn> h2WrappedCols;
    private final GridCacheContext cctx;
    private final GridH2Table table;
    private final IndexName idxName;
    private final int inlineSize;
    private final int segments;
    private final boolean isPrimary;
    private final boolean isAffinity;
    private H2RowComparator rowComparator;
    private IndexKeyTypeSettings keyTypeSettings;
    private IndexRowCache idxRowCache;
    private final QueryRowHandlerFactory rowHndFactory = new QueryRowHandlerFactory();

    public QueryIndexDefinition(GridH2Table tbl, String idxName, IndexRowCache idxRowCache, boolean isPrimary, boolean isAffinity, List<IndexColumn> h2UnwrappedCols, List<IndexColumn> h2WrappedCols, int cfgInlineSize) {
        this.idxName = new IndexName(tbl.cacheName(), tbl.getSchema().getName(), tbl.getName(), idxName);
        this.idxRowCache = idxRowCache;
        this.segments = tbl.rowDescriptor().context().config().getQueryParallelism();
        this.inlineSize = cfgInlineSize;
        this.isPrimary = isPrimary;
        this.isAffinity = isAffinity;
        this.cctx = tbl.cacheContext();
        this.table = tbl;
        this.h2WrappedCols = h2WrappedCols;
        this.h2UnwrappedCols = h2UnwrappedCols;
        this.keyTypeSettings = new IndexKeyTypeSettings().stringOptimizedCompare("OFF".equals(this.table.getCompareMode().getName())).binaryUnsigned(this.table.getCompareMode().isBinaryUnsigned());
        this.rowComparator = new H2RowComparator(this.table, this.keyTypeSettings);
    }

    public String treeName() {
        GridH2RowDescriptor rowDesc = this.table.rowDescriptor();
        String typeIdStr = "";
        if (rowDesc != null) {
            GridQueryTypeDescriptor typeDesc = rowDesc.type();
            int typeId = this.cctx.binaryMarshaller() ? typeDesc.typeId() : typeDesc.valueClass().hashCode();
            typeIdStr = typeId + "_";
        }
        return BPlusTree.treeName((String)(typeIdStr + this.idxName().idxName()), (String)"H2Tree");
    }

    public List<IndexKeyDefinition> indexKeyDefinitions() {
        if (this.keyDefs == null) {
            throw new IllegalStateException("Index key definitions is not initialized yet.");
        }
        return this.keyDefs;
    }

    public IndexRowComparator rowComparator() {
        if (this.rowComparator == null) {
            throw new IllegalStateException("Index key definitions is not initialized yet.");
        }
        return this.rowComparator;
    }

    public int segments() {
        return this.segments;
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    public boolean primary() {
        return this.isPrimary;
    }

    public boolean affinity() {
        return this.isAffinity;
    }

    public void initByMeta(boolean created, MetaPageInfo metaPageInfo) {
        if (this.keyDefs == null) {
            if (created || metaPageInfo.useUnwrappedPk()) {
                this.h2WrappedCols = null;
                this.keyDefs = new QueryIndexKeyDefinitionProvider(this.table, this.h2UnwrappedCols).keyDefinitions();
            } else {
                this.h2UnwrappedCols = null;
                this.keyDefs = new QueryIndexKeyDefinitionProvider(this.table, this.h2WrappedCols).keyDefinitions();
            }
        }
    }

    public InlineIndexRowHandlerFactory rowHandlerFactory() {
        return this.rowHndFactory;
    }

    public IndexKeyTypeSettings keyTypeSettings() {
        return this.keyTypeSettings;
    }

    public IndexRowCache idxRowCache() {
        return this.idxRowCache;
    }

    public IndexName idxName() {
        return this.idxName;
    }

    public GridH2Table getTable() {
        return this.table;
    }

    public List<IndexColumn> getColumns() {
        return this.h2UnwrappedCols != null ? this.h2UnwrappedCols : this.h2WrappedCols;
    }
}

