/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.analysis.util.MultiTermAwareComponent;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ASCIIFoldingFilterFactory
extends TokenFilterFactory
implements MultiTermAwareComponent {
    private static final String PRESERVE_ORIGINAL = "preserveOriginal";
    private final boolean preserveOriginal;

    public ASCIIFoldingFilterFactory(Map<String, String> args) {
        super(args);
        this.preserveOriginal = this.getBoolean(args, PRESERVE_ORIGINAL, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public ASCIIFoldingFilter create(TokenStream input) {
        return new ASCIIFoldingFilter(input, this.preserveOriginal);
    }

    @Override
    public AbstractAnalysisFactory getMultiTermComponent() {
        if (this.preserveOriginal) {
            HashMap<String, String> args = new HashMap<String, String>(this.getOriginalArgs());
            args.remove(PRESERVE_ORIGINAL);
            return new ASCIIFoldingFilterFactory(args);
        }
        return this;
    }
}

