/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.catboost;

import ai.catboost.CatBoostError;
import ai.catboost.CatBoostModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ignite.ml.catboost.CatboostRegressionModel;
import org.apache.ignite.ml.inference.parser.ModelParser;
import org.apache.ignite.ml.math.primitives.vector.NamedVector;

public class CatboostRegressionModelParser
implements ModelParser<NamedVector, Double, CatboostRegressionModel> {
    private static final long serialVersionUID = -8425510352746936163L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CatboostRegressionModel parse(byte[] mdl) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(mdl);){
            CatboostRegressionModel catboostRegressionModel = new CatboostRegressionModel(CatBoostModel.loadModel((InputStream)inputStream));
            return catboostRegressionModel;
        }
        catch (CatBoostError | IOException e) {
            throw new RuntimeException("Failed to parse model " + e.getMessage(), e);
        }
    }
}

