/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.mesos;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ClusterProperties {
    private static final Logger log = Logger.getLogger(ClusterProperties.class.getSimpleName());
    public static final double UNLIMITED = Double.MAX_VALUE;
    public static final String MESOS_MASTER_URL = "MESOS_MASTER_URL";
    public static final String DEFAULT_MESOS_MASTER_URL = "zk://localhost:2181/mesos";
    private String mesosUrl = "zk://localhost:2181/mesos";
    public static final String IGNITE_JVM_OPTS = "IGNITE_JVM_OPTS";
    private String jvmOpts = "";
    public static final String IGNITE_CLUSTER_NAME = "IGNITE_CLUSTER_NAME";
    public static final String DEFAULT_CLUSTER_NAME = "ignite-cluster";
    private String clusterName = "ignite-cluster";
    public static final String IGNITE_HTTP_SERVER_HOST = "IGNITE_HTTP_SERVER_HOST";
    private String httpSrvHost = null;
    public static final String IGNITE_HTTP_SERVER_PORT = "IGNITE_HTTP_SERVER_PORT";
    public static final String DEFAULT_HTTP_SERVER_PORT = "48610";
    private int httpSrvPort = Integer.valueOf("48610");
    public static final String IGNITE_TOTAL_CPU = "IGNITE_TOTAL_CPU";
    private double cpu = Double.MAX_VALUE;
    public static final String IGNITE_RUN_CPU_PER_NODE = "IGNITE_RUN_CPU_PER_NODE";
    private double cpuPerNode = Double.MAX_VALUE;
    public static final String IGNITE_TOTAL_MEMORY = "IGNITE_TOTAL_MEMORY";
    private double mem = Double.MAX_VALUE;
    public static final String IGNITE_MEMORY_PER_NODE = "IGNITE_MEMORY_PER_NODE";
    private double memPerNode = Double.MAX_VALUE;
    public static final String IGNITE_TOTAL_DISK_SPACE = "IGNITE_TOTAL_DISK_SPACE";
    private double disk = Double.MAX_VALUE;
    public static final String IGNITE_DISK_SPACE_PER_NODE = "IGNITE_DISK_SPACE_PER_NODE";
    private double diskPerNode = Double.MAX_VALUE;
    public static final String IGNITE_NODE_COUNT = "IGNITE_NODE_COUNT";
    private double nodeCnt = Double.MAX_VALUE;
    public static final String IGNITE_MIN_CPU_PER_NODE = "IGNITE_MIN_CPU_PER_NODE";
    public static final double DEFAULT_RESOURCE_MIN_CPU = 1.0;
    private double minCpu = 1.0;
    public static final String IGNITE_MIN_MEMORY_PER_NODE = "IGNITE_MIN_MEMORY_PER_NODE";
    public static final double DEFAULT_RESOURCE_MIN_MEM = 256.0;
    private double minMemory = 256.0;
    public static final String IGNITE_VERSION = "IGNITE_VERSION";
    public static final String DEFAULT_IGNITE_VERSION = "latest";
    private String igniteVer = "latest";
    public static final String IGNITE_PACKAGE_URL = "IGNITE_PACKAGE_URL";
    private String ignitePkgUrl;
    public static final String IGNITE_PACKAGE_PATH = "IGNITE_PACKAGE_PATH";
    private String ignitePkgPath;
    public static final String IGNITE_WORK_DIR = "IGNITE_WORK_DIR";
    public static final String DEFAULT_IGNITE_WORK_DIR = "ignite-releases/";
    private String igniteWorkDir = "ignite-releases/";
    public static final String IGNITE_USERS_LIBS = "IGNITE_USERS_LIBS";
    private String userLibs = null;
    public static final String IGNITE_USERS_LIBS_URL = "IGNITE_USERS_LIBS_URL";
    private String userLibsUrl = null;
    public static final String LICENCE_URL = "LICENCE_URL";
    private String licenceUrl = null;
    public static final String IGNITE_CONFIG_XML = "IGNITE_XML_CONFIG";
    private String igniteCfg = null;
    public static final String IGNITE_CONFIG_XML_URL = "IGNITE_CONFIG_XML_URL";
    public static final String IGNITE_HTTP_SERVER_IDLE_TIMEOUT = "IGNITE_HTTP_SERVER_IDLE_TIMEOUT";
    public static final long IGNITE_HTTP_SERVER_IDLE_TIMEOUT_DEFAULT = 30000L;
    private long idleTimeout = 30000L;
    private String igniteCfgUrl = null;
    public static final String IGNITE_HOSTNAME_CONSTRAINT = "IGNITE_HOSTNAME_CONSTRAINT";
    private Pattern hostnameConstraint = null;

    public String clusterName() {
        return this.clusterName;
    }

    public double cpus() {
        return this.cpu;
    }

    public void cpus(double cpu) {
        this.cpu = cpu;
    }

    public double cpusPerNode() {
        return this.cpuPerNode;
    }

    public void cpusPerNode(double cpu) {
        this.cpuPerNode = cpu;
    }

    public double memory() {
        return this.mem;
    }

    public void memory(double mem) {
        this.mem = mem;
    }

    public double memoryPerNode() {
        return this.memPerNode;
    }

    public void memoryPerNode(double mem) {
        this.memPerNode = mem;
    }

    public String jmvOpts() {
        return this.jvmOpts;
    }

    public double disk() {
        return this.disk;
    }

    public double diskPerNode() {
        return this.diskPerNode;
    }

    public double instances() {
        return this.nodeCnt;
    }

    public double minMemoryPerNode() {
        return this.minMemory;
    }

    public void minMemoryPerNode(double minMemory) {
        this.minMemory = minMemory;
    }

    public void hostnameConstraint(Pattern ptrn) {
        this.hostnameConstraint = ptrn;
    }

    public double minCpuPerNode() {
        return this.minCpu;
    }

    public void minCpuPerNode(double minCpu) {
        this.minCpu = minCpu;
    }

    public String igniteVer() {
        return this.igniteVer;
    }

    public String igniteWorkDir() {
        return this.igniteWorkDir;
    }

    public String userLibs() {
        return this.userLibs;
    }

    public String igniteCfg() {
        return this.igniteCfg;
    }

    public String masterUrl() {
        return this.mesosUrl;
    }

    public String httpServerHost() {
        return this.httpSrvHost;
    }

    public int httpServerPort() {
        return this.httpSrvPort;
    }

    public long idleTimeout() {
        return this.idleTimeout;
    }

    public String ignitePackageUrl() {
        return this.ignitePkgUrl;
    }

    public String ignitePackagePath() {
        return this.ignitePkgPath;
    }

    public String igniteConfigUrl() {
        return this.igniteCfgUrl;
    }

    public String usersLibsUrl() {
        return this.userLibsUrl;
    }

    public String licenceUrl() {
        return this.licenceUrl;
    }

    public Pattern hostnameConstraint() {
        return this.hostnameConstraint;
    }

    public static ClusterProperties from(String cfg) {
        try {
            Properties props = null;
            if (cfg != null) {
                props = new Properties();
                try (FileInputStream in = new FileInputStream(cfg);){
                    props.load(in);
                }
            }
            ClusterProperties prop = new ClusterProperties();
            prop.mesosUrl = ClusterProperties.getStringProperty(MESOS_MASTER_URL, props, DEFAULT_MESOS_MASTER_URL);
            prop.httpSrvHost = ClusterProperties.getStringProperty(IGNITE_HTTP_SERVER_HOST, props, ClusterProperties.getNonLoopbackAddress());
            String port = System.getProperty("PORT0");
            prop.httpSrvPort = port != null && !port.isEmpty() ? Integer.valueOf(port).intValue() : Integer.valueOf(ClusterProperties.getStringProperty(IGNITE_HTTP_SERVER_PORT, props, DEFAULT_HTTP_SERVER_PORT)).intValue();
            prop.clusterName = ClusterProperties.getStringProperty(IGNITE_CLUSTER_NAME, props, DEFAULT_CLUSTER_NAME);
            prop.userLibsUrl = ClusterProperties.getStringProperty(IGNITE_USERS_LIBS_URL, props, null);
            prop.ignitePkgUrl = ClusterProperties.getStringProperty(IGNITE_PACKAGE_URL, props, null);
            prop.ignitePkgPath = ClusterProperties.getStringProperty(IGNITE_PACKAGE_PATH, props, null);
            prop.licenceUrl = ClusterProperties.getStringProperty(LICENCE_URL, props, null);
            prop.igniteCfgUrl = ClusterProperties.getStringProperty(IGNITE_CONFIG_XML_URL, props, null);
            prop.cpu = ClusterProperties.getDoubleProperty(IGNITE_TOTAL_CPU, props, Double.MAX_VALUE);
            prop.cpuPerNode = ClusterProperties.getDoubleProperty(IGNITE_RUN_CPU_PER_NODE, props, Double.MAX_VALUE);
            prop.mem = ClusterProperties.getDoubleProperty(IGNITE_TOTAL_MEMORY, props, Double.MAX_VALUE);
            prop.memPerNode = ClusterProperties.getDoubleProperty(IGNITE_MEMORY_PER_NODE, props, Double.MAX_VALUE);
            prop.disk = ClusterProperties.getDoubleProperty(IGNITE_TOTAL_DISK_SPACE, props, Double.MAX_VALUE);
            prop.diskPerNode = ClusterProperties.getDoubleProperty(IGNITE_DISK_SPACE_PER_NODE, props, 1024.0);
            prop.nodeCnt = ClusterProperties.getDoubleProperty(IGNITE_NODE_COUNT, props, Double.MAX_VALUE);
            prop.minCpu = ClusterProperties.getDoubleProperty(IGNITE_MIN_CPU_PER_NODE, props, 1.0);
            prop.minMemory = ClusterProperties.getDoubleProperty(IGNITE_MIN_MEMORY_PER_NODE, props, 256.0);
            prop.jvmOpts = ClusterProperties.getStringProperty(IGNITE_JVM_OPTS, props, "");
            prop.igniteVer = ClusterProperties.getStringProperty(IGNITE_VERSION, props, DEFAULT_IGNITE_VERSION);
            prop.igniteWorkDir = ClusterProperties.getStringProperty(IGNITE_WORK_DIR, props, DEFAULT_IGNITE_WORK_DIR);
            prop.igniteCfg = ClusterProperties.getStringProperty(IGNITE_CONFIG_XML, props, null);
            prop.userLibs = ClusterProperties.getStringProperty(IGNITE_USERS_LIBS, props, null);
            String ptrn = ClusterProperties.getStringProperty(IGNITE_HOSTNAME_CONSTRAINT, props, null);
            prop.idleTimeout = ClusterProperties.getLongProperty(IGNITE_HTTP_SERVER_IDLE_TIMEOUT, props, 30000L);
            if (ptrn != null) {
                try {
                    prop.hostnameConstraint = Pattern.compile(ptrn);
                }
                catch (PatternSyntaxException e) {
                    log.log(Level.WARNING, "IGNITE_HOSTNAME_CONSTRAINT has invalid pattern. It will be ignore.", e);
                }
            }
            return prop;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static double getDoubleProperty(String name, Properties fileProps, Double dfltVal) {
        if (fileProps != null && fileProps.containsKey(name)) {
            return Double.valueOf(fileProps.getProperty(name));
        }
        String prop = System.getProperty(name);
        if (prop == null) {
            prop = System.getenv(name);
        }
        return prop == null ? dfltVal : Double.valueOf(prop);
    }

    private static long getLongProperty(String name, Properties fileProps, Long dfltVal) {
        if (fileProps != null && fileProps.containsKey(name)) {
            return Long.valueOf(fileProps.getProperty(name));
        }
        String prop = System.getProperty(name);
        if (prop == null) {
            prop = System.getenv(name);
        }
        return prop == null ? dfltVal : Long.valueOf(prop);
    }

    private static String getStringProperty(String name, Properties fileProps, String dfltVal) {
        if (fileProps != null && fileProps.containsKey(name)) {
            return fileProps.getProperty(name);
        }
        String prop = System.getProperty(name);
        if (prop == null) {
            prop = System.getenv(name);
        }
        return prop == null ? dfltVal : prop;
    }

    public static String getNonLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> addrs = iface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                return addr.getHostAddress();
            }
        }
        throw new RuntimeException("Failed. Could not find non-loopback address");
    }
}

