/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.io.Serializable;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.BinaryClassificationPointwiseMetricStatsAggregator;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetric;

public class MissRate<L extends Serializable>
extends BinaryClassificationMetric<L> {
    private static final long serialVersionUID = -8361708127709743343L;
    private Double value = Double.NaN;

    public MissRate() {
    }

    public MissRate(L truthLabel, L falseLabel) {
        super(truthLabel, falseLabel);
    }

    public MissRate<L> initBy(BinaryClassificationPointwiseMetricStatsAggregator<L> aggr) {
        int p = aggr.getTruePositive() + aggr.getFalseNegative();
        this.value = p == 0 ? 1.0 : (double)aggr.getFalseNegative() / (double)p;
        return this;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public MetricName name() {
        return MetricName.MISS_RATE;
    }
}

