/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.recommendation.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.recommendation.ObjectSubjectRatingTriplet;
import org.apache.ignite.ml.recommendation.util.RecommendationDatasetData;

public class RecommendationBinaryDatasetDataBuilder
implements PartitionDataBuilder<Object, BinaryObject, EmptyContext, RecommendationDatasetData<Serializable, Serializable>> {
    private static final long serialVersionUID = 7807817562932691037L;
    private final String objFieldName;
    private final String subjFieldName;
    private final String ratingFieldName;

    public RecommendationBinaryDatasetDataBuilder(String objFieldName, String subjFieldName, String ratingFieldName) {
        this.objFieldName = objFieldName;
        this.subjFieldName = subjFieldName;
        this.ratingFieldName = ratingFieldName;
    }

    @Override
    public RecommendationDatasetData<Serializable, Serializable> build(LearningEnvironment env, Iterator<UpstreamEntry<Object, BinaryObject>> upstreamData, long upstreamDataSize, EmptyContext ctx) {
        ArrayList<ObjectSubjectRatingTriplet<Serializable, Serializable>> ratings = new ArrayList<ObjectSubjectRatingTriplet<Serializable, Serializable>>();
        while (upstreamData.hasNext()) {
            UpstreamEntry<Object, BinaryObject> e = upstreamData.next();
            BinaryObject val = e.getValue();
            Serializable objId = (Serializable)val.field(this.objFieldName);
            Serializable subjId = (Serializable)val.field(this.subjFieldName);
            Number rating = (Number)val.field(this.ratingFieldName);
            ratings.add(new ObjectSubjectRatingTriplet<Serializable, Serializable>(objId, subjId, rating.doubleValue()));
        }
        return new RecommendationDatasetData<Serializable, Serializable>(ratings);
    }
}

