/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.naivebayes.gaussian;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.ml.Exporter;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.inference.json.JSONModelMixIn;
import org.apache.ignite.ml.inference.json.JSONWritable;
import org.apache.ignite.ml.inference.json.JacksonHelper;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.naivebayes.BayesModel;
import org.apache.ignite.ml.naivebayes.gaussian.GaussianNaiveBayesSumsHolder;

public class GaussianNaiveBayesModel
implements BayesModel<GaussianNaiveBayesModel, Vector, Double>,
JSONWritable,
DeployableObject {
    private static final long serialVersionUID = -127386523291350345L;
    private double[][] means;
    private double[][] variances;
    private double[] classProbabilities;
    private double[] labels;
    private GaussianNaiveBayesSumsHolder sumsHolder;

    public GaussianNaiveBayesModel(double[][] means, double[][] variances, double[] classProbabilities, double[] labels, GaussianNaiveBayesSumsHolder sumsHolder) {
        this.means = (double[][])means.clone();
        this.variances = (double[][])variances.clone();
        this.classProbabilities = (double[])classProbabilities.clone();
        this.labels = (double[])labels.clone();
        this.sumsHolder = sumsHolder;
    }

    public GaussianNaiveBayesModel() {
    }

    @Override
    public <P> void saveModel(Exporter<GaussianNaiveBayesModel, P> exporter, P path) {
        exporter.save(this, path);
    }

    @Override
    public Double predict(Vector vector) {
        double[] probabilityPowers = this.probabilityPowers(vector);
        int max = 0;
        for (int i = 0; i < probabilityPowers.length; ++i) {
            int n = i;
            probabilityPowers[n] = probabilityPowers[n] + Math.log(this.classProbabilities[i]);
            if (!(probabilityPowers[i] > probabilityPowers[max])) continue;
            max = i;
        }
        return this.labels[max];
    }

    @Override
    public double[] probabilityPowers(Vector vector) {
        double[] probabilityPowers = new double[this.classProbabilities.length];
        for (int i = 0; i < this.classProbabilities.length; ++i) {
            for (int j = 0; j < vector.size(); ++j) {
                double x = vector.get(j);
                double probability = GaussianNaiveBayesModel.gauss(x, this.means[i][j], this.variances[i][j]);
                int n = i;
                probabilityPowers[n] = probabilityPowers[n] + (probability > 0.0 ? Math.log(probability) : 0.0);
            }
        }
        return probabilityPowers;
    }

    public double[][] getMeans() {
        return this.means;
    }

    public double[][] getVariances() {
        return this.variances;
    }

    public double[] getClassProbabilities() {
        return this.classProbabilities;
    }

    public double[] getLabels() {
        return this.labels;
    }

    public GaussianNaiveBayesSumsHolder getSumsHolder() {
        return this.sumsHolder;
    }

    private static double gauss(double x, double mean, double variance) {
        return Math.exp(-1.0 * Math.pow(x - mean, 2.0) / (2.0 * variance)) / Math.sqrt(Math.PI * 2 * variance);
    }

    @Override
    @JsonIgnore
    public List<Object> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void toJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.addMixIn(GaussianNaiveBayesModel.class, JSONModelMixIn.class);
        ObjectWriter writer = mapper.writerFor(GaussianNaiveBayesModel.class).withAttribute((Object)"formatVersion", (Object)"1").withAttribute((Object)"timestamp", (Object)System.currentTimeMillis()).withAttribute((Object)"uid", (Object)("dt_" + UUID.randomUUID().toString())).withAttribute((Object)"modelClass", (Object)GaussianNaiveBayesModel.class.getSimpleName());
        try {
            File file = new File(path.toAbsolutePath().toString());
            writer.writeValue(file, (Object)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static GaussianNaiveBayesModel fromJSON(Path path) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JacksonHelper.readAndValidateBasicJsonModelProperties(path, mapper, GaussianNaiveBayesModel.class.getSimpleName());
            GaussianNaiveBayesModel mdl = (GaussianNaiveBayesModel)mapper.readValue(new File(path.toAbsolutePath().toString()), GaussianNaiveBayesModel.class);
            return mdl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

