/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.matrix;

import org.apache.ignite.ml.math.exceptions.math.CardinalityException;
import org.apache.ignite.ml.math.exceptions.math.SingularMatrixException;
import org.apache.ignite.ml.math.primitives.matrix.Matrix;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class LUDecomposition
implements AutoCloseable {
    private static final double DEFAULT_TOO_SMALL = 1.0E-11;
    private final Vector pivot;
    private boolean even;
    private boolean singular;
    private Matrix cachedL;
    private Matrix cachedU;
    private Matrix cachedP;
    private Matrix matrix;
    private Matrix lu;

    public LUDecomposition(Matrix matrix) {
        this(matrix, 1.0E-11);
    }

    public LUDecomposition(Matrix matrix, double singularityThreshold) {
        int cols;
        assert (matrix != null);
        int rows = matrix.rowSize();
        if (rows != (cols = matrix.columnSize())) {
            throw new CardinalityException(rows, cols);
        }
        this.matrix = matrix;
        this.lu = MatrixUtil.copy(matrix);
        this.pivot = MatrixUtil.likeVector(matrix);
        for (int i = 0; i < this.pivot.size(); ++i) {
            this.pivot.setX(i, i);
        }
        this.even = true;
        this.singular = false;
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        for (int col = 0; col < cols; ++col) {
            int i;
            for (int row = 0; row < col; ++row) {
                Vector luRow = this.lu.viewRow(row);
                double sum = luRow.get(col);
                for (int i2 = 0; i2 < row; ++i2) {
                    sum -= luRow.getX(i2) * this.lu.getX(i2, col);
                }
                luRow.setX(col, sum);
            }
            int max = col;
            double largest = Double.NEGATIVE_INFINITY;
            for (int row = col; row < rows; ++row) {
                Vector luRow = this.lu.viewRow(row);
                double sum = luRow.getX(col);
                for (i = 0; i < col; ++i) {
                    sum -= luRow.getX(i) * this.lu.getX(i, col);
                }
                luRow.setX(col, sum);
                if (!(Math.abs(sum) > largest)) continue;
                largest = Math.abs(sum);
                max = row;
            }
            if (Math.abs(this.lu.getX(max, col)) < singularityThreshold) {
                this.singular = true;
                return;
            }
            if (max != col) {
                Vector luMax = this.lu.viewRow(max);
                Vector luCol = this.lu.viewRow(col);
                for (i = 0; i < cols; ++i) {
                    double tmp = luMax.getX(i);
                    luMax.setX(i, luCol.getX(i));
                    luCol.setX(i, tmp);
                }
                int temp = (int)this.pivot.getX(max);
                this.pivot.setX(max, this.pivot.getX(col));
                this.pivot.setX(col, temp);
                this.even = !this.even;
            }
            double luDiag = this.lu.getX(col, col);
            for (int row = col + 1; row < cols; ++row) {
                double val = this.lu.getX(row, col) / luDiag;
                this.lu.setX(row, col, val);
            }
        }
    }

    @Override
    public void close() {
        if (this.cachedL != null) {
            this.cachedL.destroy();
        }
        if (this.cachedU != null) {
            this.cachedU.destroy();
        }
        if (this.cachedP != null) {
            this.cachedP.destroy();
        }
        this.lu.destroy();
    }

    public Matrix getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.size();
            this.cachedL = MatrixUtil.like(this.matrix);
            this.cachedL.assign(0.0);
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < i; ++j) {
                    this.cachedL.setX(i, j, this.lu.getX(i, j));
                }
                this.cachedL.setX(i, i, 1.0);
            }
        }
        return this.cachedL;
    }

    public Matrix getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.size();
            this.cachedU = MatrixUtil.like(this.matrix);
            this.cachedU.assign(0.0);
            for (int i = 0; i < m; ++i) {
                for (int j = i; j < m; ++j) {
                    this.cachedU.setX(i, j, this.lu.getX(i, j));
                }
            }
        }
        return this.cachedU;
    }

    public Matrix getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.size();
            this.cachedP = MatrixUtil.like(this.matrix);
            this.cachedP.assign(0.0);
            for (int i = 0; i < m; ++i) {
                this.cachedP.setX(i, (int)this.pivot.get(i), 1.0);
            }
        }
        return this.cachedP;
    }

    public Vector getPivot() {
        return this.pivot.copy();
    }

    public double determinant() {
        if (this.singular) {
            return 0.0;
        }
        int m = this.pivot.size();
        double determinant = this.even ? 1.0 : -1.0;
        for (int i = 0; i < m; ++i) {
            determinant *= this.lu.getX(i, i);
        }
        return determinant;
    }

    public Vector solve(Vector b) {
        int i;
        double bpCol;
        int col;
        int m = this.pivot.size();
        if (b.size() != m) {
            throw new CardinalityException(b.size(), m);
        }
        if (this.singular) {
            throw new SingularMatrixException();
        }
        double[] bp = new double[m];
        for (int row = 0; row < m; ++row) {
            bp[row] = b.get((int)this.pivot.get(row));
        }
        for (col = 0; col < m; ++col) {
            bpCol = bp[col];
            for (i = col + 1; i < m; ++i) {
                int n = i;
                bp[n] = bp[n] - bpCol * this.lu.get(i, col);
            }
        }
        for (col = m - 1; col >= 0; --col) {
            int n = col;
            bp[n] = bp[n] / this.lu.get(col, col);
            bpCol = bp[col];
            for (i = 0; i < col; ++i) {
                int n2 = i;
                bp[n2] = bp[n2] - bpCol * this.lu.get(i, col);
            }
        }
        return b.like(m).assign(bp);
    }

    public Matrix solve(Matrix b) {
        double[] bpCol;
        int col;
        int m = this.pivot.size();
        if (b.rowSize() != m) {
            throw new CardinalityException(b.rowSize(), m);
        }
        if (this.singular) {
            throw new SingularMatrixException();
        }
        int nColB = b.columnSize();
        double[][] bp = new double[m][nColB];
        for (int row = 0; row < m; ++row) {
            double[] bpRow = bp[row];
            int pRow = (int)this.pivot.get(row);
            for (int col2 = 0; col2 < nColB; ++col2) {
                bpRow[col2] = b.get(pRow, col2);
            }
        }
        for (col = 0; col < m; ++col) {
            bpCol = bp[col];
            for (int i = col + 1; i < m; ++i) {
                double[] bpI = bp[i];
                double luICol = this.lu.get(i, col);
                for (int j = 0; j < nColB; ++j) {
                    int n = j;
                    bpI[n] = bpI[n] - bpCol[j] * luICol;
                }
            }
        }
        for (col = m - 1; col >= 0; --col) {
            bpCol = bp[col];
            double luDiag = this.lu.getX(col, col);
            int j = 0;
            while (j < nColB) {
                int n = j++;
                bpCol[n] = bpCol[n] / luDiag;
            }
            for (int i = 0; i < col; ++i) {
                double[] bpI = bp[i];
                double luICol = this.lu.get(i, col);
                for (int j2 = 0; j2 < nColB; ++j2) {
                    int n = j2;
                    bpI[n] = bpI[n] - bpCol[j2] * luICol;
                }
            }
        }
        return b.like(b.rowSize(), b.columnSize()).assign(bp);
    }
}

