/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.cache.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.internal.util.lang.GridPeerDeployAware;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.UpstreamTransformer;
import org.apache.ignite.ml.dataset.UpstreamTransformerBuilder;
import org.apache.ignite.ml.dataset.impl.cache.util.IteratorWithConcurrentModificationChecker;
import org.apache.ignite.ml.dataset.impl.cache.util.PartitionDataStorage;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.environment.deploy.DeployingContext;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.util.Utils;

public final class ComputeUtils {
    private static final String DATA_STORAGE_KEY_TEMPLATE = "part_data_storage_%s";
    private static final String ENVIRONMENT_STORAGE_KEY_TEMPLATE = "part_environment_storage_%s";

    private ComputeUtils() {
    }

    public static <R> Collection<R> affinityCallWithRetries(Ignite ignite, Collection<String> cacheNames, IgniteFunction<Integer, R> fun, int retries, int interval, DeployingContext deployingCtx) {
        assert (!cacheNames.isEmpty());
        assert (interval >= 0);
        String primaryCache = cacheNames.iterator().next();
        Affinity affinity = ignite.affinity(primaryCache);
        int partitions = affinity.partitions();
        BitSet completionFlags = new BitSet(partitions);
        ArrayList<Object> results = new ArrayList<Object>();
        for (int t = 0; t <= retries; ++t) {
            ClusterGroup clusterGrp = ignite.cluster().forDataNodes(primaryCache);
            HashMap<Integer, IgniteFuture> futures = new HashMap<Integer, IgniteFuture>();
            for (int part = 0; part < partitions; ++part) {
                if (completionFlags.get(part)) continue;
                int currPart = part;
                futures.put(currPart, ignite.compute(clusterGrp).affinityCallAsync(cacheNames, currPart, new DeployableCallable<R>(deployingCtx, part, fun)));
            }
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    Object res = ((IgniteFuture)entry.getValue()).get();
                    results.add(res);
                    completionFlags.set((Integer)entry.getKey());
                }
                catch (IgniteException igniteException) {}
            }
            if (completionFlags.cardinality() == partitions) {
                return results;
            }
            LockSupport.parkNanos(interval * 1000000);
        }
        throw new IllegalStateException();
    }

    public static <R> Collection<R> affinityCallWithRetries(Ignite ignite, Collection<String> cacheNames, IgniteFunction<Integer, R> fun, int retries, DeployingContext deployingContext) {
        return ComputeUtils.affinityCallWithRetries(ignite, cacheNames, fun, retries, 0, deployingContext);
    }

    public static LearningEnvironment getLearningEnvironment(Ignite ignite, UUID datasetId, int part, LearningEnvironmentBuilder envBuilder) {
        ConcurrentMap envStorage = (ConcurrentMap)ignite.cluster().nodeLocalMap().computeIfAbsent(String.format(ENVIRONMENT_STORAGE_KEY_TEMPLATE, datasetId), key -> new ConcurrentHashMap());
        return envStorage.computeIfAbsent(part, envBuilder::buildForWorker);
    }

    public static <K, V, C extends Serializable, D extends AutoCloseable> D getData(Ignite ignite, String upstreamCacheName, IgniteBiPredicate<K, V> filter, UpstreamTransformerBuilder transformerBuilder, String datasetCacheName, UUID datasetId, PartitionDataBuilder<K, V, C, D> partDataBuilder, LearningEnvironment env, boolean isKeepBinary) {
        PartitionDataStorage dataStorage = (PartitionDataStorage)ignite.cluster().nodeLocalMap().computeIfAbsent(String.format(DATA_STORAGE_KEY_TEMPLATE, datasetId), key -> new PartitionDataStorage());
        int part = env.partition();
        return (D)dataStorage.computeDataIfAbsent(part, () -> {
            IgniteCache learningCtxCache = ignite.cache(datasetCacheName);
            Serializable ctx = (Serializable)learningCtxCache.get((Object)part);
            IgniteCache upstreamCache = ignite.cache(upstreamCacheName);
            if (isKeepBinary) {
                upstreamCache = upstreamCache.withKeepBinary();
            }
            ScanQuery qry = new ScanQuery();
            qry.setLocal(true);
            qry.setPartition(Integer.valueOf(part));
            qry.setFilter(filter);
            UpstreamTransformer transformer = transformerBuilder.build(env);
            UpstreamTransformer transformerCp = Utils.copy(transformer);
            long cnt = ComputeUtils.computeCount(upstreamCache, qry, transformer);
            if (cnt > 0L) {
                try (QueryCursor cursor = upstreamCache.query((Query)qry, (IgniteClosure & Serializable)e -> new UpstreamEntry<Object, Object>(e.getKey(), e.getValue()));){
                    Iterator it = cursor.iterator();
                    Stream<UpstreamEntry> transformedStream = transformerCp.transform(Utils.asStream(it, cnt).map(x -> x));
                    it = Utils.asStream(transformedStream.iterator()).map(x -> x).iterator();
                    IteratorWithConcurrentModificationChecker iter = new IteratorWithConcurrentModificationChecker(it, cnt, "Cache expected to be not modified during dataset data building [partition=" + part + ']');
                    Object d = partDataBuilder.build(env, iter, cnt, ctx);
                    return d;
                }
            }
            return null;
        });
    }

    public static void removeData(Ignite ignite, UUID datasetId) {
        ignite.cluster().nodeLocalMap().remove(String.format(DATA_STORAGE_KEY_TEMPLATE, datasetId));
    }

    public static void removeLearningEnv(Ignite ignite, UUID datasetId) {
        ignite.cluster().nodeLocalMap().remove(String.format(ENVIRONMENT_STORAGE_KEY_TEMPLATE, datasetId));
    }

    public static <K, V, C extends Serializable> void initContext(Ignite ignite, String upstreamCacheName, UpstreamTransformerBuilder transformerBuilder, IgniteBiPredicate<K, V> filter, String datasetCacheName, PartitionContextBuilder<K, V, C> ctxBuilder, LearningEnvironmentBuilder envBuilder, int retries, int interval, boolean isKeepBinary, DeployingContext deployingCtx) {
        ComputeUtils.affinityCallWithRetries(ignite, Arrays.asList(datasetCacheName, upstreamCacheName), part -> {
            Object ctx;
            Ignite locIgnite = Ignition.localIgnite();
            LearningEnvironment env = envBuilder.buildForWorker((int)part);
            IgniteCache locUpstreamCache = locIgnite.cache(upstreamCacheName);
            if (isKeepBinary) {
                locUpstreamCache = locUpstreamCache.withKeepBinary();
            }
            ScanQuery qry = new ScanQuery();
            qry.setLocal(true);
            qry.setPartition(part);
            qry.setFilter(filter);
            UpstreamTransformer transformer = transformerBuilder.build(env);
            UpstreamTransformer transformerCp = Utils.copy(transformer);
            long cnt = ComputeUtils.computeCount(locUpstreamCache, qry, transformer);
            try (QueryCursor cursor = locUpstreamCache.query((Query)qry, (IgniteClosure & Serializable)e -> new UpstreamEntry<Object, Object>(e.getKey(), e.getValue()));){
                Iterator it = cursor.iterator();
                Stream<UpstreamEntry> transformedStream = transformerCp.transform(Utils.asStream(it, cnt).map(x -> x));
                it = Utils.asStream(transformedStream.iterator()).map(x -> x).iterator();
                IteratorWithConcurrentModificationChecker iter = new IteratorWithConcurrentModificationChecker(it, cnt, "Cache expected to be not modified during dataset data building [partition=" + part + ']');
                ctx = ctxBuilder.build(env, iter, cnt);
            }
            IgniteCache datasetCache = locIgnite.cache(datasetCacheName);
            datasetCache.put(part, ctx);
            return part;
        }, retries, interval, deployingCtx);
    }

    public static <C extends Serializable> C getContext(Ignite ignite, String datasetCacheName, int part) {
        IgniteCache datasetCache = ignite.cache(datasetCacheName);
        return (C)((Serializable)datasetCache.get((Object)part));
    }

    public static <C extends Serializable> void saveContext(Ignite ignite, String datasetCacheName, int part, C ctx) {
        IgniteCache datasetCache = ignite.cache(datasetCacheName);
        datasetCache.put((Object)part, ctx);
    }

    private static <K, V> long computeCount(IgniteCache<K, V> cache, ScanQuery<K, V> qry, UpstreamTransformer transformer) {
        try (QueryCursor cursor = cache.query(qry, (IgniteClosure & Serializable)e -> new UpstreamEntry<Object, Object>(e.getKey(), e.getValue()));){
            long l = ComputeUtils.computeCount(transformer.transform(Utils.asStream(cursor.iterator()).map(x -> x)).iterator());
            return l;
        }
    }

    private static long computeCount(Iterator<?> iter) {
        long res = 0L;
        while (iter.hasNext()) {
            iter.next();
            ++res;
        }
        return res;
    }

    private static class DeployableCallable<C>
    implements GridPeerDeployAware,
    IgniteCallable<C> {
        private final IgniteFunction<Integer, C> fun;
        private final int part;
        private transient DeployingContext deployingContext;

        public DeployableCallable(DeployingContext deployingCtx, int part, IgniteFunction<Integer, C> fun) {
            this.fun = fun;
            this.deployingContext = deployingCtx;
            this.part = part;
        }

        public C call() throws Exception {
            return (C)this.fun.apply(this.part);
        }

        public Class<?> deployClass() {
            return this.deployingContext.userClass();
        }

        public ClassLoader classLoader() {
            return this.deployingContext.clientClassLoader();
        }
    }
}

