/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.KeyMetadata;

public class KeyMetadataJsonMarshaller {
    private static KeyMetadataJsonMarshaller instance;

    public void marshall(KeyMetadata keyMetadata, StructuredJsonGenerator jsonGenerator) {
        if (keyMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (keyMetadata.getAWSAccountId() != null) {
                jsonGenerator.writeFieldName("AWSAccountId").writeValue(keyMetadata.getAWSAccountId());
            }
            if (keyMetadata.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(keyMetadata.getKeyId());
            }
            if (keyMetadata.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(keyMetadata.getArn());
            }
            if (keyMetadata.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(keyMetadata.getCreationDate());
            }
            if (keyMetadata.getEnabled() != null) {
                jsonGenerator.writeFieldName("Enabled").writeValue(keyMetadata.getEnabled().booleanValue());
            }
            if (keyMetadata.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(keyMetadata.getDescription());
            }
            if (keyMetadata.getKeyUsage() != null) {
                jsonGenerator.writeFieldName("KeyUsage").writeValue(keyMetadata.getKeyUsage());
            }
            if (keyMetadata.getKeyState() != null) {
                jsonGenerator.writeFieldName("KeyState").writeValue(keyMetadata.getKeyState());
            }
            if (keyMetadata.getDeletionDate() != null) {
                jsonGenerator.writeFieldName("DeletionDate").writeValue(keyMetadata.getDeletionDate());
            }
            if (keyMetadata.getValidTo() != null) {
                jsonGenerator.writeFieldName("ValidTo").writeValue(keyMetadata.getValidTo());
            }
            if (keyMetadata.getOrigin() != null) {
                jsonGenerator.writeFieldName("Origin").writeValue(keyMetadata.getOrigin());
            }
            if (keyMetadata.getExpirationModel() != null) {
                jsonGenerator.writeFieldName("ExpirationModel").writeValue(keyMetadata.getExpirationModel());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeyMetadataJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyMetadataJsonMarshaller();
        }
        return instance;
    }
}

