/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.h2.table.Column;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class ObjectHashInlineIndexColumn
extends AbstractInlineIndexColumn {
    public ObjectHashInlineIndexColumn(Column col) {
        super(col, 19, (short)4);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        int val2;
        if (this.type() != type || type != v.getType()) {
            return Integer.MIN_VALUE;
        }
        int val1 = PageUtils.getInt((long)pageAddr, (int)(off + 1));
        int res = Integer.signum(Integer.compare(val1, val2 = v.getObject().hashCode()));
        return res == 0 ? -2 : res;
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
        PageUtils.putInt((long)pageAddr, (int)(off + 1), (int)val.getObject().hashCode());
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        int hashCode = PageUtils.getInt((long)pageAddr, (int)(off + 1));
        return new ValueObjectHashCode(hashCode);
    }

    ValueInt inlinedValue(long pageAddr, int off) {
        return ValueInt.get((int)PageUtils.getInt((long)pageAddr, (int)(off + 1)));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType() == this.type());
        return this.size() + 1;
    }

    private static class ValueObjectHashCode
    extends Value {
        public static final int PRECISION = 10;
        public static final int DISPLAY_SIZE = 11;
        private final int value;

        public ValueObjectHashCode(int value) {
            this.value = value;
        }

        public String getSQL() {
            return this.getString();
        }

        public int getType() {
            return 19;
        }

        public int getInt() {
            return this.value;
        }

        public long getLong() {
            return this.value;
        }

        protected int compareSecure(Value o, CompareMode mode) {
            ValueObjectHashCode v = (ValueObjectHashCode)o;
            return Integer.compare(this.value, v.value);
        }

        public String getString() {
            return String.valueOf(this.value);
        }

        public long getPrecision() {
            return 10L;
        }

        public int hashCode() {
            return this.value;
        }

        public Object getObject() {
            return this.value;
        }

        public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
            prep.setInt(parameterIndex, this.value);
        }

        public int getDisplaySize() {
            return 11;
        }

        public boolean equals(Object other) {
            return other instanceof ValueObjectHashCode && this.value == ((ValueObjectHashCode)((Object)other)).value;
        }
    }
}

