/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsHolderIndex;
import org.apache.ignite.internal.metric.IoStatisticsType;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTask;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIoResolver;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.DurableBackgroundCleanupIndexTreeTask;
import org.apache.ignite.internal.processors.query.h2.H2Cursor;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeFilterClosure;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.opt.join.CursorIteratorWrapper;
import org.apache.ignite.internal.processors.query.h2.opt.join.DistributedJoinContext;
import org.apache.ignite.internal.processors.query.h2.opt.join.DistributedLookupBatch;
import org.apache.ignite.internal.processors.query.h2.opt.join.RangeSource;
import org.apache.ignite.internal.processors.query.h2.opt.join.RangeStream;
import org.apache.ignite.internal.processors.query.h2.opt.join.SegmentKey;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2IndexRangeResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRange;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2RowRangeBounds;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessage;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.typedef.CIX2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2TreeIndex
extends H2TreeIndexBase {
    private final H2Tree[] segments;
    private final GridKernalContext ctx;
    private final GridCacheContext<?, ?> cctx;
    private final String tblName;
    private final String idxName;
    private final String treeName;
    private final IgniteLogger log;
    private final Object msgTopic;
    private final GridMessageListener msgLsnr;
    private final CIX2<ClusterNode, Message> locNodeHnd = new CIX2<ClusterNode, Message>(){

        public void applyx(ClusterNode locNode, Message msg) {
            H2TreeIndex.this.onMessage0(locNode.id(), msg);
        }
    };
    public static H2TreeFactory h2TreeFactory = H2Tree::new;
    private final QueryContextRegistry qryCtxRegistry;
    private final IoStatisticsHolderIndex stats;
    private final AtomicBoolean destroyed = new AtomicBoolean();

    private H2TreeIndex(GridCacheContext<?, ?> cctx, final GridH2Table tbl, String idxName, boolean pk, String treeName, H2Tree[] segments, IoStatisticsHolderIndex stats, IndexColumn[] cols, IgniteLogger log) {
        super(tbl, idxName, cols, pk ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false));
        this.cctx = cctx;
        this.ctx = cctx.kernalContext();
        this.log = log;
        this.tblName = tbl.getName();
        this.idxName = idxName;
        this.treeName = treeName;
        this.segments = segments;
        this.stats = stats;
        this.qryCtxRegistry = ((IgniteH2Indexing)this.ctx.query().getIndexing()).queryContextRegistry();
        this.msgTopic = new IgniteBiTuple((Object)GridTopic.TOPIC_QUERY, (Object)(tbl.identifierString() + '.' + this.getName()));
        this.msgLsnr = new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                GridSpinBusyLock l = tbl.rowDescriptor().indexing().busyLock();
                if (!l.enterBusy()) {
                    return;
                }
                try {
                    H2TreeIndex.this.onMessage0(nodeId, msg);
                }
                finally {
                    l.leaveBusy();
                }
            }
        };
        this.ctx.io().addMessageListener(this.msgTopic, this.msgLsnr);
    }

    public static H2TreeIndex createIndex(GridCacheContext<?, ?> cctx, @Nullable H2RowCache rowCache, GridH2Table tbl, String idxName, boolean pk, boolean affinityKey, List<IndexColumn> unwrappedCols, List<IndexColumn> wrappedCols, int inlineSize, int segmentsCnt, IgniteLogger log) throws IgniteCheckedException {
        return H2TreeIndex.createIndex(cctx, rowCache, tbl, idxName, pk, affinityKey, unwrappedCols, wrappedCols, inlineSize, segmentsCnt, cctx.dataRegion().pageMemory(), cctx.offheap(), PageIoResolver.DEFAULT_PAGE_IO_RESOLVER, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static H2TreeIndex createIndex(GridCacheContext<?, ?> cctx, @Nullable H2RowCache rowCache, GridH2Table tbl, String idxName, boolean pk, boolean affinityKey, List<IndexColumn> unwrappedCols, List<IndexColumn> wrappedCols, int inlineSize, int segmentsCnt, PageMemory pageMemory, IgniteCacheOffheapManager offheap, PageIoResolver pageIoRslvr, IgniteLogger log) throws IgniteCheckedException {
        assert (segmentsCnt > 0) : segmentsCnt;
        GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
        int typeId = cctx.binaryMarshaller() ? typeDesc.typeId() : typeDesc.valueClass().hashCode();
        String treeName = BPlusTree.treeName((String)((tbl.rowDescriptor() == null ? "" : typeId + "_") + idxName), (String)"H2Tree");
        assert (cctx.affinityNode());
        H2Tree[] segments = new H2Tree[segmentsCnt];
        IgniteCacheDatabaseSharedManager db = cctx.shared().database();
        AtomicInteger maxCalculatedInlineSize = new AtomicInteger();
        IoStatisticsHolderIndex stats = new IoStatisticsHolderIndex(IoStatisticsType.SORTED_INDEX, cctx.name(), idxName, cctx.kernalContext().metric());
        InlineIndexColumnFactory idxHelperFactory = new InlineIndexColumnFactory(tbl.getCompareMode());
        for (int i = 0; i < segments.length; ++i) {
            db.checkpointReadLock();
            try {
                RootPage page = H2TreeIndex.getMetaPage(offheap, cctx, treeName, i);
                segments[i] = h2TreeFactory.create(cctx, tbl, treeName, idxName, tbl.getName(), tbl.cacheName(), offheap.reuseListForIndex(treeName), cctx.groupId(), cctx.group().name(), pageMemory, cctx.shared().wal(), (AtomicLong)offheap.globalRemoveId(), page.pageId().pageId(), page.isAllocated(), unwrappedCols, wrappedCols, maxCalculatedInlineSize, pk, affinityKey, cctx.mvccEnabled(), rowCache, cctx.kernalContext().failure(), log, (IoStatisticsHolder)stats, idxHelperFactory, inlineSize, pageIoRslvr);
                continue;
            }
            finally {
                db.checkpointReadUnlock();
            }
        }
        IndexColumn[] cols = segments[0].cols();
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        return new H2TreeIndex(cctx, tbl, idxName, pk, treeName, segments, stats, cols, log);
    }

    @Override
    public int inlineSize() {
        return this.segments[0].inlineSize();
    }

    public boolean rebuildRequired() {
        assert (this.segments != null);
        for (int i = 0; i < this.segments.length; ++i) {
            try {
                H2Tree segment = this.segments[i];
                if (!segment.created()) continue;
                return true;
            }
            catch (Exception e) {
                throw new IgniteException("Failed to check index tree root page existence [cacheName=" + this.cctx.name() + ", tblName=" + this.tblName + ", idxName=" + this.idxName + ", segment=" + i + ']');
            }
        }
        return false;
    }

    @Override
    public int segmentsCount() {
        return this.segments.length;
    }

    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        assert (lower == null || lower instanceof H2Row) : lower;
        assert (upper == null || upper instanceof H2Row) : upper;
        try {
            QueryContext qctx = ses != null ? H2Utils.context(ses) : null;
            int seg = this.segment(qctx);
            H2Tree tree = this.treeForRead(seg);
            if (this.isSingleRowLookup(lower, upper, tree)) {
                H2Row row = (H2Row)tree.findOne((H2Row)lower, this.filter(qctx), null);
                if (row == null || H2TreeIndex.isExpired(row)) {
                    return GridH2Cursor.EMPTY;
                }
                return new SingleRowCursor((Row)row);
            }
            return new H2Cursor((GridCursor<H2Row>)tree.find((H2Row)lower, (H2Row)upper, this.filter(qctx), null));
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    private boolean isSingleRowLookup(SearchRow lower, SearchRow upper, H2Tree tree) {
        return !this.cctx.mvccEnabled() && this.indexType.isPrimaryKey() && lower != null && upper != null && tree.checkRowsTheSame((H2Row)lower, (H2Row)upper) && this.hasAllIndexColumns(lower);
    }

    private boolean hasAllIndexColumns(SearchRow searchRow) {
        for (Column c : this.columns) {
            if (searchRow.getValue(c.getColumnId()) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public H2CacheRow put(H2CacheRow row) {
        try {
            int seg = this.segmentForRow(this.cctx, (SearchRow)row);
            H2Tree tree = this.treeForRead(seg);
            InlineIndexColumnFactory.setCurrentInlineIndexes(tree.inlineIndexes());
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            H2CacheRow h2CacheRow = (H2CacheRow)tree.put(row);
            return h2CacheRow;
        }
        catch (Throwable t) {
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, t));
            throw DbException.convert((Throwable)t);
        }
        finally {
            InlineIndexColumnFactory.clearCurrentInlineIndexes();
        }
    }

    private void validateRowFields(H2CacheRow row) {
        for (int col : this.columnIds) {
            row.getValue(col);
        }
    }

    @Override
    public boolean putx(H2CacheRow row) {
        this.validateRowFields(row);
        try {
            int seg = this.segmentForRow(this.cctx, (SearchRow)row);
            H2Tree tree = this.treeForRead(seg);
            InlineIndexColumnFactory.setCurrentInlineIndexes(tree.inlineIndexes());
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            boolean bl = tree.putx(row);
            return bl;
        }
        catch (Throwable t) {
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, t));
            throw DbException.convert((Throwable)t);
        }
        finally {
            InlineIndexColumnFactory.clearCurrentInlineIndexes();
        }
    }

    @Override
    public boolean removex(SearchRow row) {
        assert (row instanceof H2Row) : row;
        try {
            int seg = this.segmentForRow(this.cctx, row);
            H2Tree tree = this.treeForRead(seg);
            InlineIndexColumnFactory.setCurrentInlineIndexes(tree.inlineIndexes());
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            boolean bl = tree.removex((H2Row)row);
            return bl;
        }
        catch (Throwable t) {
            this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, t));
            throw DbException.convert((Throwable)t);
        }
        finally {
            InlineIndexColumnFactory.clearCurrentInlineIndexes();
        }
    }

    public long getRowCount(Session ses) {
        try {
            QueryContext qctx = H2Utils.context(ses);
            int seg = this.segment(qctx);
            H2Tree tree = this.treeForRead(seg);
            return tree.size(this.filter(qctx));
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public Cursor findFirstOrLast(Session ses, boolean b) {
        try {
            H2Row found;
            QueryContext qctx = H2Utils.context(ses);
            H2Tree tree = this.treeForRead(this.segment(qctx));
            H2Row h2Row = found = b ? (H2Row)tree.findFirst(this.filter(qctx)) : (H2Row)tree.findLast(this.filter(qctx));
            if (found == null || H2TreeIndex.isExpired(found)) {
                return GridH2Cursor.EMPTY;
            }
            return new SingleRowCursor((Row)found);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    private static boolean isExpired(@NotNull H2Row row) {
        return row.expireTime() > 0L && row.expireTime() <= U.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(boolean rmvIdx) {
        block11: {
            if (!this.markDestroyed()) {
                return;
            }
            try {
                if (!this.cctx.affinityNode() || !rmvIdx) break block11;
                ArrayList<Long> rootPages = new ArrayList<Long>(this.segments.length);
                ArrayList<H2Tree> trees = new ArrayList<H2Tree>(this.segments.length);
                this.cctx.shared().database().checkpointReadLock();
                try {
                    for (int i = 0; i < this.segments.length; ++i) {
                        H2Tree tree = this.segments[i];
                        tree.markDestroyed();
                        rootPages.add(tree.getMetaPageId());
                        trees.add(tree);
                        this.dropMetaPage(i);
                    }
                }
                finally {
                    this.cctx.shared().database().checkpointReadUnlock();
                }
                this.ctx.metric().remove(this.stats.metricRegistryName());
                DurableBackgroundCleanupIndexTreeTask task = new DurableBackgroundCleanupIndexTreeTask(rootPages, trees, this.cctx.group().name(), this.cctx.cache().name(), this.table.getSchema().getName(), this.idxName);
                this.cctx.kernalContext().durableBackgroundTasksProcessor().startDurableBackgroundTask((DurableBackgroundTask)task, this.cctx.config());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
            finally {
                if (this.msgLsnr != null) {
                    this.ctx.io().removeMessageListener(this.msgTopic, this.msgLsnr);
                }
            }
        }
    }

    public H2Tree treeForRead(int segment) {
        return this.segments[segment];
    }

    private BPlusTree.TreeRowClosure<H2Row, H2Row> filter(QueryContext qctx) {
        if (qctx == null) {
            assert (!this.cctx.mvccEnabled());
            return null;
        }
        IndexingQueryFilter f = qctx.filter();
        IndexingQueryCacheFilter p = f == null ? null : f.forCache(this.getTable().cacheName());
        MvccSnapshot v = qctx.mvccSnapshot();
        assert (!this.cctx.mvccEnabled() || v != null);
        if (p == null && v == null) {
            return null;
        }
        return new H2TreeFilterClosure(p, v, this.cctx, this.log);
    }

    private static RootPage getMetaPage(IgniteCacheOffheapManager offheap, GridCacheContext<?, ?> cctx, String treeName, int segIdx) throws IgniteCheckedException {
        return offheap.rootPageForIndex(cctx.cacheId(), treeName, segIdx);
    }

    private void dropMetaPage(int segIdx) throws IgniteCheckedException {
        this.cctx.offheap().dropRootPageForIndex(this.cctx.cacheId(), this.treeName, segIdx);
    }

    @Override
    public long totalRowCount(IndexingQueryCacheFilter partsFilter) {
        try {
            H2TreeFilterClosure filter = partsFilter == null ? null : new H2TreeFilterClosure(partsFilter, null, this.cctx, this.log);
            long cnt = 0L;
            for (int seg = 0; seg < this.segmentsCount(); ++seg) {
                cnt += this.segments[seg].size(filter);
            }
            return cnt;
        }
        catch (IgniteCheckedException e) {
            throw U.convertException((IgniteCheckedException)e);
        }
    }

    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter) {
        QueryContext qctx = H2Utils.context(filters[filter].getSession());
        if (qctx == null || qctx.distributedJoinContext() == null || !this.getTable().isPartitioned()) {
            return null;
        }
        IndexColumn affCol = this.getTable().getAffinityKeyColumn();
        GridH2RowDescriptor desc = this.getTable().rowDescriptor();
        int affColId = -1;
        boolean ucast = false;
        if (affCol != null) {
            affColId = affCol.column.getColumnId();
            int[] masks = filters[filter].getMasks();
            if (masks != null) {
                ucast = (masks[affColId] & 1) != 0 || desc.checkKeyIndexCondition(masks, 1);
            }
        }
        return new DistributedLookupBatch(this, this.cctx, ucast, affColId);
    }

    public void send(Collection<ClusterNode> nodes, Message msg) {
        boolean res = this.getTable().rowDescriptor().indexing().send(this.msgTopic, -1, nodes, msg, null, (IgniteInClosure2X<ClusterNode, Message>)this.locNodeHnd, (byte)7, false);
        if (!res) {
            throw H2Utils.retryException("Failed to send message to nodes: " + nodes);
        }
    }

    private void onMessage0(UUID nodeId, Object msg) {
        block6: {
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                return;
            }
            try {
                if (msg instanceof GridH2IndexRangeRequest) {
                    this.onIndexRangeRequest(node, (GridH2IndexRangeRequest)msg);
                } else if (msg instanceof GridH2IndexRangeResponse) {
                    this.onIndexRangeResponse(node, (GridH2IndexRangeResponse)msg);
                }
            }
            catch (Throwable th) {
                U.error((IgniteLogger)this.log, (Object)("Failed to handle message[nodeId=" + nodeId + ", msg=" + msg + "]"), (Throwable)th);
                if (!(th instanceof Error)) break block6;
                throw th;
            }
        }
    }

    private void onIndexRangeRequest(ClusterNode node, GridH2IndexRangeRequest msg) {
        Span span = MTC.span();
        try (MTC.TraceSurroundings trace = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_IDX_RANGE_REQ, MTC.span()));){
            span.addTag("sql.index", () -> this.idxName);
            span.addTag("sql.table", () -> this.tblName);
            GridH2IndexRangeResponse res = new GridH2IndexRangeResponse();
            res.originNodeId(msg.originNodeId());
            res.queryId(msg.queryId());
            res.originSegmentId(msg.originSegmentId());
            res.segment(msg.segment());
            res.batchLookupId(msg.batchLookupId());
            QueryContext qctx = this.qryCtxRegistry.getShared(msg.originNodeId(), msg.queryId(), msg.originSegmentId());
            if (qctx == null) {
                res.status((byte)2);
            } else {
                DistributedJoinContext joinCtx = qctx.distributedJoinContext();
                assert (joinCtx != null);
                try {
                    GridH2RowRange range;
                    RangeSource src;
                    if (msg.bounds() != null) {
                        assert (!msg.bounds().isEmpty()) : "empty bounds";
                        src = new RangeSource(this, msg.bounds(), msg.segment(), this.filter(qctx));
                    } else {
                        src = (RangeSource)joinCtx.getSource(node.id(), msg.segment(), msg.batchLookupId());
                        assert (src != null);
                    }
                    ArrayList<GridH2RowRange> ranges = new ArrayList<GridH2RowRange>();
                    int maxRows = joinCtx.pageSize();
                    assert (maxRows > 0) : maxRows;
                    while (maxRows > 0 && (range = src.next(maxRows)) != null) {
                        ranges.add(range);
                        if (range.rows() == null) continue;
                        maxRows -= range.rows().size();
                    }
                    assert (!ranges.isEmpty());
                    if (src.hasMoreRows()) {
                        if (msg.bounds() != null) {
                            joinCtx.putSource(node.id(), msg.segment(), msg.batchLookupId(), src);
                        }
                    } else if (msg.bounds() == null) {
                        joinCtx.putSource(node.id(), msg.segment(), msg.batchLookupId(), null);
                    }
                    res.ranges(ranges);
                    res.status((byte)0);
                    span.addTag("sql.index.range.rows", () -> Integer.toString(ranges.stream().mapToInt(GridH2RowRange::rowsSize).sum()));
                }
                catch (Throwable th) {
                    span.addTag("error", th::getMessage);
                    U.error((IgniteLogger)this.log, (Object)("Failed to process request: " + msg), (Throwable)th);
                    res.error(th.getClass() + ": " + th.getMessage());
                    res.status((byte)1);
                }
            }
            this.send(Collections.singletonList(node), res);
        }
    }

    private void onIndexRangeResponse(ClusterNode node, GridH2IndexRangeResponse msg) {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.ctx.tracing().create(SpanType.SQL_IDX_RANGE_RESP, MTC.span()));){
            QueryContext qctx = this.qryCtxRegistry.getShared(msg.originNodeId(), msg.queryId(), msg.originSegmentId());
            if (qctx == null) {
                return;
            }
            DistributedJoinContext joinCtx = qctx.distributedJoinContext();
            assert (joinCtx != null);
            Map streams = (Map)joinCtx.getStreams(msg.batchLookupId());
            if (streams == null) {
                return;
            }
            RangeStream stream = (RangeStream)streams.get(new SegmentKey(node, msg.segment()));
            assert (stream != null);
            stream.onResponse(msg);
        }
    }

    public Iterator<H2Row> findForSegment(GridH2RowRangeBounds bounds, int segment, BPlusTree.TreeRowClosure<H2Row, H2Row> filter) {
        SearchRow first = this.toSearchRow(bounds.first());
        SearchRow last = this.toSearchRow(bounds.last());
        H2Tree t = this.treeForRead(segment);
        try {
            GridCursor<H2Row> range = ((BPlusTree)t).find((Object)first, (Object)last, filter, null);
            if (range == null) {
                range = H2Utils.EMPTY_CURSOR;
            }
            H2Cursor cur = new H2Cursor(range);
            return new CursorIteratorWrapper(cur);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    private SearchRow toSearchRow(GridH2RowMessage msg) {
        if (msg == null) {
            return null;
        }
        Value[] vals = new Value[this.getTable().getColumns().length];
        assert (vals.length > 0);
        List<GridH2ValueMessage> msgVals = msg.values();
        for (int i = 0; i < this.indexColumns.length; ++i) {
            if (i >= msgVals.size()) continue;
            try {
                vals[this.indexColumns[i].column.getColumnId()] = msgVals.get(i).value(this.ctx);
                continue;
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return this.database.createRow(vals, -1);
    }

    public GridH2RowMessage toSearchRowMessage(SearchRow row) {
        if (row == null) {
            return null;
        }
        ArrayList<GridH2ValueMessage> vals = new ArrayList<GridH2ValueMessage>(this.indexColumns.length);
        for (IndexColumn idxCol : this.indexColumns) {
            Value val = row.getValue(idxCol.column.getColumnId());
            if (val == null) break;
            try {
                vals.add(GridH2ValueMessageFactory.toMessage(val));
            }
            catch (IgniteCheckedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        GridH2RowMessage res = new GridH2RowMessage();
        res.values(vals);
        return res;
    }

    public long size() throws IgniteCheckedException {
        long ret = 0L;
        for (int i = 0; i < this.segmentsCount(); ++i) {
            H2Tree tree = this.treeForRead(i);
            ret += tree.size();
        }
        return ret;
    }

    private boolean markDestroyed() {
        return this.destroyed.compareAndSet(false, true);
    }

    public static interface H2TreeFactory {
        public H2Tree create(GridCacheContext var1, GridH2Table var2, String var3, String var4, String var5, String var6, ReuseList var7, int var8, String var9, PageMemory var10, IgniteWriteAheadLogManager var11, AtomicLong var12, long var13, boolean var15, List<IndexColumn> var16, List<IndexColumn> var17, AtomicInteger var18, boolean var19, boolean var20, boolean var21, @Nullable H2RowCache var22, @Nullable FailureProcessor var23, IgniteLogger var24, IoStatisticsHolder var25, InlineIndexColumnFactory var26, int var27, PageIoResolver var28) throws IgniteCheckedException;
    }
}

