/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.util.Collections;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.AbstractCommand;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCancelTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCreateTask;

public class SnapshotCommand
extends AbstractCommand<Object> {
    private Object taskArgs;
    private String taskName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger log) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Object r = TaskExecutor.executeTaskByNameOnNode(client, this.taskName, this.taskArgs, null, clientCfg);
            return r;
        }
        catch (Throwable e) {
            log.severe("Failed to perform operation.");
            log.severe(CommandLogger.errorMessage(e));
            throw e;
        }
    }

    @Override
    public Object arg() {
        return this.taskArgs;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        SnapshotSubcommand cmd = SnapshotSubcommand.of(argIter.nextArg("Expected snapshot action."));
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct action.");
        }
        switch (cmd) {
            case CREATE: {
                this.taskName = VisorSnapshotCreateTask.class.getName();
                this.taskArgs = argIter.nextArg("Expected snapshot name.");
                break;
            }
            case CANCEL: {
                this.taskName = VisorSnapshotCancelTask.class.getName();
                this.taskArgs = argIter.nextArg("Expected snapshot name.");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown snapshot sub-command: " + (Object)((Object)cmd));
            }
        }
    }

    @Override
    public void printUsage(Logger log) {
        Command.usage(log, "Create cluster snapshot:", CommandList.SNAPSHOT, Collections.singletonMap("snapshot_name", "Snapshot name."), SnapshotSubcommand.CREATE.toString(), "snapshot_name");
        Command.usage(log, "Cancel running snapshot:", CommandList.SNAPSHOT, Collections.singletonMap("snapshot_name", "Snapshot name."), SnapshotSubcommand.CANCEL.toString(), "snapshot_name");
    }

    @Override
    public String name() {
        return CommandList.SNAPSHOT.toCommandName();
    }
}

