/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.transactions.spring;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.configuration.ClientTransactionConfiguration;
import org.apache.ignite.internal.transactions.proxy.ClientTransactionProxyFactory;
import org.apache.ignite.internal.transactions.proxy.TransactionProxyFactory;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.spring.AbstractSpringTransactionManager;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class IgniteClientSpringTransactionManager
extends AbstractSpringTransactionManager {
    private static final IgniteLogger NOOP_LOG = new NullLogger();
    private IgniteClient cli;

    public IgniteClient getClientInstance() {
        return this.cli;
    }

    public void setClientInstance(IgniteClient cli) {
        this.cli = cli;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent evt) {
        if (this.cli == null) {
            throw new IllegalArgumentException("Failed to obtain thin client instance for accessing the Ignite cluster. Check that 'clientInstance' property is set.");
        }
        super.onApplicationEvent(evt);
    }

    @Override
    protected TransactionIsolation defaultTransactionIsolation() {
        return ClientTransactionConfiguration.DFLT_TX_ISOLATION;
    }

    @Override
    protected long defaultTransactionTimeout() {
        return 0L;
    }

    @Override
    protected TransactionConcurrency defaultTransactionConcurrency() {
        return ClientTransactionConfiguration.DFLT_TX_CONCURRENCY;
    }

    @Override
    protected TransactionProxyFactory createTransactionFactory() {
        return new ClientTransactionProxyFactory(this.cli.transactions());
    }

    @Override
    protected IgniteLogger log() {
        return NOOP_LOG;
    }

    @Override
    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        ((AbstractSpringTransactionManager.IgniteTransactionObject)status.getTransaction()).getTransactionHolder().setRollbackOnly();
    }
}

