/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.indexing;

import java.util.HashSet;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.jetbrains.annotations.Nullable;

public class IndexingQueryFilterImpl
implements IndexingQueryFilter {
    private final GridKernalContext ctx;
    private final AffinityTopologyVersion topVer;
    private final HashSet<Integer> parts;
    private final boolean treatReplicatedAsPartitioned;

    public IndexingQueryFilterImpl(GridKernalContext ctx, @Nullable AffinityTopologyVersion topVer, @Nullable int[] partsArr, boolean treatReplicatedAsPartitioned) {
        this.ctx = ctx;
        AffinityTopologyVersion affinityTopologyVersion = this.topVer = topVer != null ? topVer : AffinityTopologyVersion.NONE;
        if (F.isEmpty(partsArr)) {
            this.parts = null;
        } else {
            this.parts = new HashSet();
            for (int part : partsArr) {
                this.parts.add(part);
            }
        }
        this.treatReplicatedAsPartitioned = treatReplicatedAsPartitioned;
    }

    public IndexingQueryFilterImpl(GridKernalContext ctx, @Nullable AffinityTopologyVersion topVer, @Nullable int[] partsArr) {
        this(ctx, topVer, partsArr, false);
    }

    @Override
    @Nullable
    public IndexingQueryCacheFilter forCache(String cacheName) {
        GridCacheAdapter cache = this.ctx.cache().internalCache(cacheName);
        if (cache.context().isReplicated() && !this.treatReplicatedAsPartitioned) {
            return null;
        }
        return new IndexingQueryCacheFilter(cache.context().affinity(), this.parts, this.topVer, this.ctx.discovery().localNode());
    }
}

