/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.encryption.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.keystore.KeystoreEncryptionKey;
import org.jetbrains.annotations.Nullable;

public class KeystoreEncryptionSpi
extends IgniteSpiAdapter
implements EncryptionSpi {
    public static final String DEFAULT_MASTER_KEY_NAME = "ignite.master.key";
    public static final String CIPHER_ALGO = "AES";
    public static final int DEFAULT_KEY_SIZE = 256;
    private static final String AES_WITH_PADDING = "AES/CBC/PKCS5Padding";
    private static final String AES_WITHOUT_PADDING = "AES/CBC/NoPadding";
    private static final String DIGEST_ALGO = "SHA-512";
    private static final int BLOCK_SZ = 16;
    private String keyStorePath;
    private char[] keyStorePwd;
    private int keySize = 256;
    private volatile KeystoreEncryptionKey masterKey;
    private volatile String masterKeyName = "ignite.master.key";
    @LoggerResource
    protected IgniteLogger log;
    private static final ThreadLocal<Cipher> aesWithPadding = ThreadLocal.withInitial(() -> {
        try {
            return Cipher.getInstance(AES_WITH_PADDING);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IgniteException(e);
        }
    });
    private static final ThreadLocal<Cipher> aesWithoutPadding = ThreadLocal.withInitial(() -> {
        try {
            return Cipher.getInstance(AES_WITHOUT_PADDING);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IgniteException(e);
        }
    });

    @Override
    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        this.loadMasterKey(this.masterKeyName);
    }

    @Override
    public void spiStop() throws IgniteSpiException {
        this.ensureStarted();
    }

    @Override
    public byte[] masterKeyDigest() {
        this.ensureStarted();
        return this.makeDigest(this.masterKey.key().getEncoded());
    }

    @Override
    public KeystoreEncryptionKey create() throws IgniteException {
        this.ensureStarted();
        try {
            KeyGenerator gen = KeyGenerator.getInstance(CIPHER_ALGO);
            gen.init(this.keySize);
            SecretKey key = gen.generateKey();
            return new KeystoreEncryptionKey(key, this.makeDigest(key.getEncoded()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public void encrypt(ByteBuffer data, Serializable key, ByteBuffer res) {
        this.doEncryption(data, aesWithPadding.get(), key, res);
    }

    @Override
    public void encryptNoPadding(ByteBuffer data, Serializable key, ByteBuffer res) {
        this.doEncryption(data, aesWithoutPadding.get(), key, res);
    }

    @Override
    public byte[] decrypt(byte[] data, Serializable key) {
        assert (key instanceof KeystoreEncryptionKey);
        this.ensureStarted();
        try {
            SecretKeySpec keySpec = new SecretKeySpec(((KeystoreEncryptionKey)key).key().getEncoded(), CIPHER_ALGO);
            Cipher cipher = aesWithPadding.get();
            cipher.init(2, (Key)keySpec, new IvParameterSpec(data, 0, cipher.getBlockSize()));
            return cipher.doFinal(data, cipher.getBlockSize(), data.length - cipher.getBlockSize());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new IgniteSpiException(e);
        }
    }

    @Override
    public void decryptNoPadding(ByteBuffer data, Serializable key, ByteBuffer res) {
        assert (key instanceof KeystoreEncryptionKey);
        this.ensureStarted();
        try {
            SecretKeySpec keySpec = new SecretKeySpec(((KeystoreEncryptionKey)key).key().getEncoded(), CIPHER_ALGO);
            Cipher cipher = aesWithoutPadding.get();
            byte[] iv = new byte[cipher.getBlockSize()];
            data.get(iv);
            cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
            cipher.doFinal(data, res);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new IgniteSpiException(e);
        }
    }

    private void doEncryption(ByteBuffer data, Cipher cipher, Serializable key, ByteBuffer res) {
        assert (key instanceof KeystoreEncryptionKey);
        this.ensureStarted();
        try {
            SecretKeySpec keySpec = new SecretKeySpec(((KeystoreEncryptionKey)key).key().getEncoded(), CIPHER_ALGO);
            byte[] iv = this.initVector(cipher);
            res.put(iv);
            cipher.init(1, (Key)keySpec, new IvParameterSpec(iv));
            cipher.doFinal(data, res);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new IgniteSpiException(e);
        }
    }

    @Override
    public byte[] encryptKey(Serializable key) {
        assert (key instanceof KeystoreEncryptionKey);
        byte[] serKey = U.toBytes(key);
        byte[] res = new byte[this.encryptedSize(serKey.length)];
        this.encrypt(ByteBuffer.wrap(serKey), this.masterKey, ByteBuffer.wrap(res));
        return res;
    }

    @Override
    public KeystoreEncryptionKey decryptKey(byte[] data) {
        byte[] serKey = this.decrypt(data, this.masterKey);
        KeystoreEncryptionKey key = (KeystoreEncryptionKey)U.fromBytes(serKey);
        byte[] digest = this.makeDigest(key.key().getEncoded());
        if (!Arrays.equals(key.digest, digest)) {
            throw new IgniteException("Key is broken!");
        }
        return key;
    }

    @Override
    public int encryptedSize(int dataSize) {
        return this.encryptedSize(dataSize, AES_WITH_PADDING);
    }

    @Override
    public int encryptedSizeNoPadding(int dataSize) {
        return this.encryptedSize(dataSize, AES_WITHOUT_PADDING);
    }

    @Override
    public int blockSize() {
        return 16;
    }

    @Override
    public String getMasterKeyName() {
        return this.masterKeyName;
    }

    @Override
    public void setMasterKeyName(String masterKeyName) {
        this.masterKeyName = masterKeyName;
        if (this.started()) {
            this.loadMasterKey(masterKeyName);
        }
    }

    private int encryptedSize(int dataSize, String algo) {
        int cntBlocks;
        switch (algo) {
            case "AES/CBC/PKCS5Padding": {
                cntBlocks = 2;
                break;
            }
            case "AES/CBC/NoPadding": {
                cntBlocks = 1;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm: " + algo);
            }
        }
        return (dataSize / 16 + cntBlocks) * 16;
    }

    private byte[] makeDigest(byte[] msg) {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGO);
            return md.digest(msg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IgniteException(e);
        }
    }

    private byte[] initVector(Cipher cipher) {
        byte[] iv = new byte[cipher.getBlockSize()];
        ThreadLocalRandom.current().nextBytes(iv);
        return iv;
    }

    private InputStream keyStoreFile() throws IOException {
        File abs = new File(this.keyStorePath);
        if (abs.exists()) {
            return new FileInputStream(abs);
        }
        URL clsPthRes = KeystoreEncryptionSpi.class.getClassLoader().getResource(this.keyStorePath);
        if (clsPthRes != null) {
            return clsPthRes.openStream();
        }
        return null;
    }

    private void ensureStarted() throws IgniteException {
        if (this.started()) {
            return;
        }
        throw new IgniteException("EncryptionSpi is not started!");
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        assert (!F.isEmpty(keyStorePath)) : "KeyStore path shouldn't be empty";
        assert (!this.started()) : "Spi already started";
        this.keyStorePath = keyStorePath;
    }

    public char[] getKeyStorePwd() {
        return this.keyStorePwd;
    }

    public void setKeyStorePassword(char[] keyStorePassword) {
        assert (keyStorePassword != null && keyStorePassword.length > 0);
        assert (!this.started()) : "Spi already started";
        this.keyStorePwd = keyStorePassword;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        assert (!this.started()) : "Spi already started";
        this.keySize = keySize;
    }

    private void loadMasterKey(String masterKeyName) {
        this.assertParameter(!F.isEmpty(this.keyStorePath), "KeyStorePath shouldn't be empty");
        this.assertParameter(this.keyStorePwd != null && this.keyStorePwd.length > 0, "KeyStorePassword shouldn't be empty");
        try (InputStream keyStoreFile = this.keyStoreFile();){
            Key key;
            this.assertParameter(keyStoreFile != null, this.keyStorePath + " doesn't exists!");
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(keyStoreFile, this.keyStorePwd);
            if (this.log != null) {
                this.log.info("Successfully load keyStore [path=" + this.keyStorePath + "]");
            }
            this.assertParameter((key = ks.getKey(masterKeyName, this.keyStorePwd)) != null, "No such master key found [masterKeyName=" + masterKeyName + ']');
            this.masterKey = new KeystoreEncryptionKey(key, null);
            this.masterKeyName = masterKeyName;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IgniteSpiException(e);
        }
    }
}

