/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.IOException;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.MisdirectedRequestException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConformance
implements HttpRequestInterceptor {
    public static final RequestConformance INSTANCE = new RequestConformance();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        String hostName;
        Args.notNull(request, "HTTP request");
        if (TextUtils.isBlank(request.getScheme())) {
            throw new ProtocolException("Request scheme is not set");
        }
        if (TextUtils.isBlank(request.getPath())) {
            throw new ProtocolException("Request path is not set");
        }
        URIAuthority authority = request.getAuthority();
        if (authority != null && (URIScheme.HTTP.same(request.getScheme()) || URIScheme.HTTPS.same(request.getScheme())) && TextUtils.isBlank(hostName = authority.getHostName())) {
            throw new ProtocolException("Request host is empty");
        }
        if (URIScheme.HTTPS.same(request.getScheme()) && context.getAttribute("http.ssl-session") == null) {
            throw new MisdirectedRequestException("HTTPS request over non-secure connection");
        }
    }
}

