/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hc.core5.util.TimeValue;

public class SocksProxy {
    private final int port;
    private final List<SocksProxyHandler> handlers = new ArrayList<SocksProxyHandler>();
    private ServerSocket server;
    private Thread serverThread;

    public SocksProxy() {
        this(0);
    }

    public SocksProxy(int port) {
        this.port = port;
    }

    public synchronized void start() throws IOException {
        if (this.server == null) {
            this.server = new ServerSocket(this.port);
            this.serverThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block10: {
                        try {
                            try {
                                while (true) {
                                    Socket socket = SocksProxy.this.server.accept();
                                    SocksProxy.this.startSocksProxyHandler(socket);
                                }
                            }
                            catch (IOException e) {
                                if (SocksProxy.this.server == null) break block10;
                                try {
                                    SocksProxy.this.server.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                SocksProxy.this.server = null;
                            }
                        }
                        catch (Throwable throwable) {
                            if (SocksProxy.this.server != null) {
                                try {
                                    SocksProxy.this.server.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                SocksProxy.this.server = null;
                            }
                            throw throwable;
                        }
                    }
                }
            });
            this.serverThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(TimeValue timeout) throws InterruptedException {
        long waitTime;
        long waitUntil = System.currentTimeMillis() + timeout.toMilliseconds();
        Thread t = null;
        SocksProxy socksProxy = this;
        synchronized (socksProxy) {
            if (this.server != null) {
                try {
                    this.server.close();
                }
                catch (IOException e) {
                }
                finally {
                    this.server = null;
                }
                t = this.serverThread;
                this.serverThread = null;
            }
            for (SocksProxyHandler handler : this.handlers) {
                handler.shutdown();
            }
            while (!this.handlers.isEmpty()) {
                long waitTime2 = waitUntil - System.currentTimeMillis();
                if (waitTime2 <= 0L) continue;
                this.wait(waitTime2);
            }
        }
        if (t != null && (waitTime = waitUntil - System.currentTimeMillis()) > 0L) {
            t.join(waitTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSocksProxyHandler(Socket socket) {
        SocksProxyHandler handler = new SocksProxyHandler(this, socket);
        SocksProxy socksProxy = this;
        synchronized (socksProxy) {
            this.handlers.add(handler);
        }
        handler.start();
    }

    protected synchronized void cleanupSocksProxyHandler(SocksProxyHandler handler) {
        this.handlers.remove(handler);
    }

    public SocketAddress getProxyAddress() {
        return this.server.getLocalSocketAddress();
    }

    private static class SocksProxyHandler {
        public static final int VERSION_5 = 5;
        public static final int COMMAND_CONNECT = 1;
        public static final int ATYP_IPV4 = 1;
        public static final int ATYP_DOMAINNAME = 3;
        public static final int ATYP_IPV6 = 4;
        private final SocksProxy parent;
        private final Socket socket;
        private volatile Socket remote;

        public SocksProxyHandler(SocksProxy parent, Socket socket) {
            this.parent = parent;
            this.socket = socket;
        }

        public void start() {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DataInputStream input = new DataInputStream(SocksProxyHandler.this.socket.getInputStream());
                        DataOutputStream output = new DataOutputStream(SocksProxyHandler.this.socket.getOutputStream());
                        Socket target = this.establishConnection(input, output);
                        SocksProxyHandler.this.remote = target;
                        Thread t1 = this.pumpStream(input, target.getOutputStream());
                        Thread t2 = this.pumpStream(target.getInputStream(), output);
                        try {
                            t1.join();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        try {
                            t2.join();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        SocksProxyHandler.this.parent.cleanupSocksProxyHandler(SocksProxyHandler.this);
                    }
                }

                private Socket establishConnection(DataInputStream input, DataOutputStream output) throws IOException {
                    byte[] targetAddress;
                    String targetHost;
                    int clientVersion = input.readUnsignedByte();
                    if (clientVersion != 5) {
                        throw new IOException("SOCKS implementation only supports version 5");
                    }
                    int nMethods = input.readUnsignedByte();
                    for (int i = 0; i < nMethods; ++i) {
                        input.readUnsignedByte();
                    }
                    output.writeByte(5);
                    output.writeByte(0);
                    output.flush();
                    input.readUnsignedByte();
                    int command = input.readUnsignedByte();
                    if (command != 1) {
                        throw new IOException("SOCKS implementation only supports CONNECT command");
                    }
                    input.readUnsignedByte();
                    int addressType = input.readUnsignedByte();
                    switch (addressType) {
                        case 1: {
                            int i;
                            targetHost = null;
                            targetAddress = new byte[4];
                            for (i = 0; i < targetAddress.length; ++i) {
                                targetAddress[i] = input.readByte();
                            }
                            break;
                        }
                        case 4: {
                            int i;
                            targetHost = null;
                            targetAddress = new byte[16];
                            for (i = 0; i < targetAddress.length; ++i) {
                                targetAddress[i] = input.readByte();
                            }
                            break;
                        }
                        case 3: {
                            int length = input.readUnsignedByte();
                            StringBuilder domainname = new StringBuilder();
                            for (int i = 0; i < length; ++i) {
                                domainname.append((char)input.readUnsignedByte());
                            }
                            targetHost = domainname.toString();
                            targetAddress = null;
                            break;
                        }
                        default: {
                            throw new IOException("Unsupported address type: " + addressType);
                        }
                    }
                    int targetPort = input.readUnsignedShort();
                    Socket target = targetHost != null ? new Socket(targetHost, targetPort) : new Socket(InetAddress.getByAddress(targetAddress), targetPort);
                    output.writeByte(5);
                    output.writeByte(0);
                    output.writeByte(0);
                    byte[] localAddress = target.getLocalAddress().getAddress();
                    if (localAddress.length == 4) {
                        output.writeByte(1);
                    } else if (localAddress.length == 16) {
                        output.writeByte(4);
                    } else {
                        throw new IOException("Unsupported localAddress byte length: " + localAddress.length);
                    }
                    output.write(localAddress);
                    output.writeShort(target.getLocalPort());
                    output.flush();
                    return target;
                }

                private Thread pumpStream(final InputStream input, final OutputStream output) {
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            byte[] buffer = new byte[8192];
                            try {
                                int read;
                                while ((read = input.read(buffer)) >= 0) {
                                    output.write(buffer, 0, read);
                                    output.flush();
                                }
                            }
                            catch (IOException iOException) {
                            }
                            finally {
                                SocksProxyHandler.this.shutdown();
                            }
                        }
                    });
                    t.start();
                    return t;
                }
            }).start();
        }

        public void shutdown() {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (this.remote != null) {
                try {
                    this.remote.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

