/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.InternalChannel;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.TransportSecurityLayerEx;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLIOSession;
import org.apache.hc.core5.reactor.ssl.SSLMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Timeout;

final class InternalDataChannel
extends InternalChannel
implements ProtocolIOSession,
TransportSecurityLayerEx {
    private final IOSession ioSession;
    private final NamedEndpoint initialEndpoint;
    private final IOSessionListener sessionListener;
    private final AtomicReference<SSLIOSession> tlsSessionRef;
    private final Queue<InternalDataChannel> closedSessions;
    private final Queue<FutureCallback<ProtocolIOSession>> callbackQueue;
    private final AtomicBoolean closed;

    InternalDataChannel(IOSession ioSession, NamedEndpoint initialEndpoint, IOSessionListener sessionListener, Queue<InternalDataChannel> closedSessions) {
        this.ioSession = ioSession;
        this.initialEndpoint = initialEndpoint;
        this.closedSessions = closedSessions;
        this.sessionListener = sessionListener;
        this.tlsSessionRef = new AtomicReference<Object>(null);
        this.callbackQueue = new LinkedList<FutureCallback<ProtocolIOSession>>();
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public String getId() {
        return this.ioSession.getId();
    }

    @Override
    public NamedEndpoint getInitialEndpoint() {
        return this.initialEndpoint;
    }

    @Override
    public IOEventHandler getHandler() {
        return this.ioSession.getHandler();
    }

    @Override
    public void upgrade(IOEventHandler handler) {
        this.ioSession.upgrade(handler);
    }

    private IOSession getSessionImpl() {
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        return tlsSession != null ? tlsSession : this.ioSession;
    }

    private IOEventHandler ensureHandler(IOSession session) {
        IOEventHandler handler = session.getHandler();
        Asserts.notNull(handler, "IO event handler");
        return handler;
    }

    @Override
    void onIOEvent(int readyOps) throws IOException {
        IOEventHandler handler;
        IOSession currentSession;
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        IOSession iOSession = currentSession = tlsSession != null ? tlsSession : this.ioSession;
        if ((readyOps & 8) != 0) {
            currentSession.clearEvent(8);
            if (tlsSession == null) {
                if (this.sessionListener != null) {
                    this.sessionListener.connected(this);
                }
                handler = this.ensureHandler(currentSession);
                handler.connected(this);
            }
        }
        if ((readyOps & 1) != 0) {
            currentSession.updateReadTime();
            if (this.sessionListener != null) {
                this.sessionListener.inputReady(this);
            }
            handler = this.ensureHandler(currentSession);
            handler.inputReady(this, null);
        }
        if ((readyOps & 4) != 0 || (this.ioSession.getEventMask() & 4) != 0) {
            currentSession.updateWriteTime();
            if (this.sessionListener != null) {
                this.sessionListener.outputReady(this);
            }
            handler = this.ensureHandler(currentSession);
            handler.outputReady(this);
        }
    }

    @Override
    Timeout getTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    void onTimeout(Timeout timeout) throws IOException {
        if (this.sessionListener != null) {
            this.sessionListener.timeout(this);
        }
        IOSession currentSession = this.getSessionImpl();
        IOEventHandler handler = this.ensureHandler(currentSession);
        handler.timeout(this, timeout);
    }

    @Override
    void onException(Exception cause) {
        IOSession currentSession;
        IOEventHandler handler;
        if (this.sessionListener != null) {
            this.sessionListener.exception(this, cause);
        }
        if ((handler = (currentSession = this.getSessionImpl()).getHandler()) != null) {
            handler.exception(this, cause);
        }
        this.notifySubscribers(cause);
    }

    void onTLSSessionStart(SSLIOSession sslSession) {
        if (this.sessionListener != null) {
            this.sessionListener.connected(this);
        }
        this.notifySubscribers();
    }

    void onTLSSessionEnd() {
        if (this.closed.compareAndSet(false, true)) {
            this.closedSessions.add(this);
        }
        this.cancelSubscribers();
    }

    void disconnected() {
        SSLIOSession tlsSession;
        IOSession currentSession;
        IOEventHandler handler;
        if (this.sessionListener != null) {
            this.sessionListener.disconnected(this);
        }
        if ((handler = (currentSession = (tlsSession = this.tlsSessionRef.get()) != null ? tlsSession : this.ioSession).getHandler()) != null) {
            handler.disconnected(this);
        }
    }

    @Override
    public void startTls(SSLContext sslContext, NamedEndpoint endpoint, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier, Timeout handshakeTimeout) {
        if (this.tlsSessionRef.compareAndSet(null, new SSLIOSession(endpoint != null ? endpoint : this.initialEndpoint, this.ioSession, this.initialEndpoint != null ? SSLMode.CLIENT : SSLMode.SERVER, sslContext, sslBufferMode, initializer, verifier, new Callback<SSLIOSession>(){

            @Override
            public void execute(SSLIOSession sslSession) {
                InternalDataChannel.this.onTLSSessionStart(sslSession);
            }
        }, new Callback<SSLIOSession>(){

            @Override
            public void execute(SSLIOSession sslSession) {
                InternalDataChannel.this.onTLSSessionEnd();
            }
        }, handshakeTimeout))) {
            if (this.sessionListener != null) {
                this.sessionListener.startTls(this);
            }
        } else {
            throw new IllegalStateException("TLS already activated");
        }
    }

    @Override
    public TlsDetails getTlsDetails() {
        SSLIOSession sslIoSession = this.tlsSessionRef.get();
        return sslIoSession != null ? sslIoSession.getTlsDetails() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(FutureCallback<ProtocolIOSession> callback) {
        if (callback == null) {
            return;
        }
        Queue<FutureCallback<ProtocolIOSession>> queue = this.callbackQueue;
        synchronized (queue) {
            TlsDetails tlsDetails;
            if (this.getSessionImpl().getStatus() != IOSession.Status.ACTIVE) {
                callback.failed(new ConnectionClosedException());
                return;
            }
            SSLIOSession sslIoSession = this.tlsSessionRef.get();
            TlsDetails tlsDetails2 = tlsDetails = sslIoSession != null ? sslIoSession.getTlsDetails() : null;
            if (tlsDetails != null) {
                callback.completed(this);
            } else {
                this.callbackQueue.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySubscribers() {
        Queue<FutureCallback<ProtocolIOSession>> queue = this.callbackQueue;
        synchronized (queue) {
            FutureCallback<ProtocolIOSession> callback;
            while ((callback = this.callbackQueue.poll()) != null) {
                callback.completed(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySubscribers(Exception ex) {
        Queue<FutureCallback<ProtocolIOSession>> queue = this.callbackQueue;
        synchronized (queue) {
            FutureCallback<ProtocolIOSession> callback;
            while ((callback = this.callbackQueue.poll()) != null) {
                callback.failed(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelSubscribers() {
        Queue<FutureCallback<ProtocolIOSession>> queue = this.callbackQueue;
        synchronized (queue) {
            FutureCallback<ProtocolIOSession> callback;
            while ((callback = this.callbackQueue.poll()) != null) {
                callback.cancelled();
            }
        }
    }

    @Override
    public Lock getLock() {
        return this.ioSession.getLock();
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(CloseMode closeMode) {
        if (closeMode == CloseMode.IMMEDIATE) {
            this.closed.set(true);
            this.getSessionImpl().close(closeMode);
        } else if (this.closed.compareAndSet(false, true)) {
            try {
                this.getSessionImpl().close(closeMode);
            }
            finally {
                this.closedSessions.add(this);
            }
        }
    }

    @Override
    public IOSession.Status getStatus() {
        return this.getSessionImpl().getStatus();
    }

    @Override
    public boolean isOpen() {
        return this.getSessionImpl().isOpen();
    }

    @Override
    public void enqueue(Command command, Command.Priority priority) {
        this.getSessionImpl().enqueue(command, priority);
    }

    @Override
    public boolean hasCommands() {
        return this.getSessionImpl().hasCommands();
    }

    @Override
    public Command poll() {
        return this.getSessionImpl().poll();
    }

    @Override
    public ByteChannel channel() {
        return this.getSessionImpl().channel();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public int getEventMask() {
        return this.getSessionImpl().getEventMask();
    }

    @Override
    public void setEventMask(int ops) {
        this.getSessionImpl().setEventMask(ops);
    }

    @Override
    public void setEvent(int op) {
        this.getSessionImpl().setEvent(op);
    }

    @Override
    public void clearEvent(int op) {
        this.getSessionImpl().clearEvent(op);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.getSessionImpl().read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.getSessionImpl().write(src);
    }

    @Override
    public void updateReadTime() {
        this.ioSession.updateReadTime();
    }

    @Override
    public void updateWriteTime() {
        this.ioSession.updateWriteTime();
    }

    @Override
    public long getLastReadTime() {
        return this.ioSession.getLastReadTime();
    }

    @Override
    public long getLastWriteTime() {
        return this.ioSession.getLastWriteTime();
    }

    @Override
    public long getLastEventTime() {
        return this.ioSession.getLastEventTime();
    }

    public String toString() {
        SSLIOSession tlsSession = this.tlsSessionRef.get();
        if (tlsSession != null) {
            return tlsSession.toString();
        }
        return this.ioSession.toString();
    }
}

