/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.BitSet;
import java.util.Locale;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.Ports;
import org.apache.hc.core5.util.LangUtils;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Tokenizer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class URIAuthority
implements NamedEndpoint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String userInfo;
    private final String hostname;
    private final int port;
    private static final BitSet HOST_SEPARATORS = new BitSet(256);
    private static final BitSet PORT_SEPARATORS = new BitSet(256);
    private static final BitSet TERMINATORS = new BitSet(256);

    static URISyntaxException createException(CharSequence input, Tokenizer.Cursor cursor, String reason) {
        return new URISyntaxException(input.subSequence(cursor.getLowerBound(), cursor.getUpperBound()).toString(), reason, cursor.getPos());
    }

    static URIAuthority parse(CharSequence s, Tokenizer.Cursor cursor) throws URISyntaxException {
        int port;
        Tokenizer tokenizer = Tokenizer.INSTANCE;
        String userInfo = null;
        int initPos = cursor.getPos();
        String token = tokenizer.parseContent(s, cursor, HOST_SEPARATORS);
        if (!cursor.atEnd() && s.charAt(cursor.getPos()) == '@') {
            cursor.updatePos(cursor.getPos() + 1);
            if (!TextUtils.isBlank(token)) {
                userInfo = token;
            }
        } else {
            cursor.updatePos(initPos);
        }
        String hostName = tokenizer.parseContent(s, cursor, PORT_SEPARATORS);
        String portText = null;
        if (!cursor.atEnd() && s.charAt(cursor.getPos()) == ':') {
            cursor.updatePos(cursor.getPos() + 1);
            portText = tokenizer.parseContent(s, cursor, TERMINATORS);
        }
        if (!TextUtils.isBlank(portText)) {
            try {
                port = Integer.parseInt(portText);
            }
            catch (NumberFormatException ex) {
                throw URIAuthority.createException(s, cursor, "Authority port is invalid");
            }
        } else {
            port = -1;
        }
        return new URIAuthority(userInfo, hostName.toLowerCase(Locale.ROOT), port, true);
    }

    static URIAuthority parse(CharSequence s) throws URISyntaxException {
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, s.length());
        return URIAuthority.parse(s, cursor);
    }

    static void format(StringBuilder buf, URIAuthority uriAuthority) {
        if (uriAuthority.userInfo != null) {
            buf.append(uriAuthority.userInfo);
            buf.append("@");
        }
        buf.append(uriAuthority.hostname);
        if (uriAuthority.port != -1) {
            buf.append(":");
            buf.append(uriAuthority.port);
        }
    }

    static String format(URIAuthority uriAuthority) {
        StringBuilder buf = new StringBuilder();
        URIAuthority.format(buf, uriAuthority);
        return buf.toString();
    }

    private URIAuthority(String userInfo, String hostname, int port, boolean internal) {
        this.userInfo = userInfo;
        this.hostname = hostname;
        this.port = Ports.checkWithDefault(port);
    }

    public URIAuthority(String userInfo, String hostname, int port) {
        this.userInfo = userInfo;
        this.hostname = hostname != null ? hostname.toLowerCase(Locale.ROOT) : null;
        this.port = Ports.checkWithDefault(port);
    }

    public URIAuthority(String hostname, int port) {
        this(null, hostname, port);
    }

    public URIAuthority(NamedEndpoint namedEndpoint) {
        this(null, namedEndpoint.getHostName(), namedEndpoint.getPort());
    }

    public static URIAuthority create(String s) throws URISyntaxException {
        if (TextUtils.isBlank(s)) {
            return null;
        }
        Tokenizer.Cursor cursor = new Tokenizer.Cursor(0, s.length());
        URIAuthority uriAuthority = URIAuthority.parse(s, cursor);
        if (!cursor.atEnd()) {
            throw URIAuthority.createException(s, cursor, "Unexpected content");
        }
        return uriAuthority;
    }

    public URIAuthority(String hostname) {
        this(null, hostname, -1);
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    @Override
    public String getHostName() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        return URIAuthority.format(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof URIAuthority) {
            URIAuthority that = (URIAuthority)obj;
            return LangUtils.equals(this.userInfo, that.userInfo) && LangUtils.equals(this.hostname, that.hostname) && this.port == that.port;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.userInfo);
        hash = LangUtils.hashCode(hash, this.hostname);
        hash = LangUtils.hashCode(hash, this.port);
        return hash;
    }

    static {
        TERMINATORS.set(47);
        TERMINATORS.set(35);
        TERMINATORS.set(63);
        HOST_SEPARATORS.or(TERMINATORS);
        HOST_SEPARATORS.set(64);
        PORT_SEPARATORS.or(TERMINATORS);
        PORT_SEPARATORS.set(58);
    }
}

