/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.ssl;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.reactor.EndpointParameters;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import org.apache.hc.core5.reactor.TransportSecurityLayerEx;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class TlsUpgradeHandler
implements ProtocolUpgradeHandler {
    private final HttpVersionPolicy versionPolicy;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public TlsUpgradeHandler(HttpVersionPolicy versionPolicy, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    public void upgrade(ProtocolIOSession ioSession, EndpointParameters parameters, FutureCallback<ProtocolIOSession> callback) {
        TransportSecurityLayerEx transportSecurityLayer;
        Args.notNull((Object)parameters, (String)"Endpoint parameters");
        if (ioSession instanceof TransportSecurityLayerEx) {
            transportSecurityLayer = (TransportSecurityLayerEx)ioSession;
            if (callback != null) {
                transportSecurityLayer.subscribe(callback);
            }
        } else {
            throw new UnsupportedOperationException("TLS upgrade not supported");
        }
        this.tlsStrategy.upgrade((TransportSecurityLayer)transportSecurityLayer, new HttpHost(parameters.getScheme(), parameters.getHostName(), parameters.getPort()), ioSession.getLocalAddress(), ioSession.getRemoteAddress(), (Object)this.versionPolicy, this.handshakeTimeout);
    }
}

