/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.impl.nio.AbstractH2UpgradeHandler;
import org.apache.hc.core5.http2.impl.nio.H2OnlyServerHttpProtocolNegotiator;
import org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ServerH2UpgradeHandler
extends AbstractH2UpgradeHandler {
    private final ServerH2StreamMultiplexerFactory http2StreamHandlerFactory;

    public ServerH2UpgradeHandler(ServerH2StreamMultiplexerFactory http2StreamHandlerFactory, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        super(tlsStrategy, handshakeTimeout);
        this.http2StreamHandlerFactory = (ServerH2StreamMultiplexerFactory)Args.notNull((Object)http2StreamHandlerFactory, (String)"HTTP/2 stream handler factory");
    }

    @Override
    protected HttpConnectionEventHandler createProtocolNegotiator(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> callback) {
        return new H2OnlyServerHttpProtocolNegotiator(ioSession, this.http2StreamHandlerFactory, callback);
    }
}

