/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import org.apache.hc.core5.concurrent.CallbackContribution;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.reactor.EndpointParameters;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ProtocolUpgradeHandler;
import org.apache.hc.core5.reactor.TransportSecurityLayerEx;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

abstract class AbstractH2UpgradeHandler
implements ProtocolUpgradeHandler {
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    AbstractH2UpgradeHandler(TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    protected abstract HttpConnectionEventHandler createProtocolNegotiator(ProtocolIOSession var1, FutureCallback<ProtocolIOSession> var2);

    private void negotiateHttp(ProtocolIOSession ioSession, FutureCallback<ProtocolIOSession> callback) {
        HttpConnectionEventHandler protocolNegotiator = this.createProtocolNegotiator(ioSession, callback);
        ioSession.upgrade((IOEventHandler)protocolNegotiator);
        try {
            protocolNegotiator.connected((IOSession)ioSession);
        }
        catch (IOException ex) {
            protocolNegotiator.exception((IOSession)ioSession, (Exception)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void upgrade(final ProtocolIOSession ioSession, EndpointParameters parameters, final FutureCallback<ProtocolIOSession> callback) {
        Args.notNull((Object)parameters, (String)"Endpoint parameters");
        if (URIScheme.HTTPS.same(parameters.getScheme())) {
            if (!(ioSession instanceof TransportSecurityLayerEx)) throw new UnsupportedOperationException("TLS upgrade not supported");
            TransportSecurityLayerEx transportSecurityLayer = (TransportSecurityLayerEx)ioSession;
            transportSecurityLayer.subscribe((FutureCallback)new CallbackContribution<ProtocolIOSession>(callback){

                public void completed(ProtocolIOSession result) {
                    AbstractH2UpgradeHandler.this.negotiateHttp(ioSession, (FutureCallback<ProtocolIOSession>)callback);
                }
            });
            this.tlsStrategy.upgrade((TransportSecurityLayer)transportSecurityLayer, new HttpHost(parameters.getScheme(), parameters.getHostName(), parameters.getPort()), ioSession.getLocalAddress(), ioSession.getRemoteAddress(), (Object)HttpVersionPolicy.FORCE_HTTP_2, this.handshakeTimeout);
            return;
        } else {
            this.negotiateHttp(ioSession, callback);
        }
    }
}

