/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.nio.EndpointParameters;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.impl.nio.ServerH2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ServerHttpProtocolNegotiator;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ServerHttpProtocolNegotiatorFactory
implements IOEventHandlerFactory {
    private final ServerHttp1StreamDuplexerFactory http1StreamDuplexerFactory;
    private final ServerH2StreamMultiplexerFactory http2StreamMultiplexerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public ServerHttpProtocolNegotiatorFactory(ServerHttp1StreamDuplexerFactory http1StreamDuplexerFactory, ServerH2StreamMultiplexerFactory http2StreamMultiplexerFactory, HttpVersionPolicy versionPolicy, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.http1StreamDuplexerFactory = (ServerHttp1StreamDuplexerFactory)Args.notNull((Object)http1StreamDuplexerFactory, (String)"HTTP/1.1 stream handler factory");
        this.http2StreamMultiplexerFactory = (ServerH2StreamMultiplexerFactory)Args.notNull((Object)http2StreamMultiplexerFactory, (String)"HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    public ServerHttpProtocolNegotiator createHandler(ProtocolIOSession ioSession, Object attachment) {
        HttpVersionPolicy endpointPolicy = this.versionPolicy;
        if (attachment instanceof EndpointParameters) {
            EndpointParameters params = (EndpointParameters)attachment;
            if (this.tlsStrategy != null && URIScheme.HTTPS.same(params.scheme)) {
                this.tlsStrategy.upgrade((TransportSecurityLayer)ioSession, null, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), params.attachment, this.handshakeTimeout);
            }
            if (params.attachment instanceof HttpVersionPolicy) {
                endpointPolicy = (HttpVersionPolicy)((Object)params.attachment);
            }
        } else {
            this.tlsStrategy.upgrade((TransportSecurityLayer)ioSession, null, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), attachment, this.handshakeTimeout);
        }
        return new ServerHttpProtocolNegotiator(ioSession, this.http1StreamDuplexerFactory, this.http2StreamMultiplexerFactory, endpointPolicy);
    }
}

