/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.impl.H2Processors;
import org.apache.hc.core5.http2.nio.support.DefaultAsyncPushConsumerFactory;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.testing.nio.AsyncRequester;
import org.apache.hc.core5.testing.nio.ClientSessionEndpoint;
import org.apache.hc.core5.testing.nio.InternalClientH2EventHandlerFactory;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

public class H2TestClient
extends AsyncRequester {
    private final SSLContext sslContext;
    private final RequestHandlerRegistry<Supplier<AsyncPushConsumer>> registry;

    public H2TestClient(IOReactorConfig ioReactorConfig, SSLContext sslContext) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
        this.registry = new RequestHandlerRegistry();
    }

    public H2TestClient() throws IOException {
        this(IOReactorConfig.DEFAULT, (SSLContext)null);
    }

    public void register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notNull((Object)uriPattern, (String)"URI pattern");
        Args.notNull(supplier, (String)"Supplier");
        this.registry.register(null, uriPattern, supplier);
    }

    public void start(IOEventHandlerFactory handlerFactory) throws IOException {
        super.execute(handlerFactory);
    }

    public void start(HttpProcessor httpProcessor, H2Config h2Config) throws IOException {
        this.start(new InternalClientH2EventHandlerFactory(httpProcessor, (HandlerFactory<AsyncPushConsumer>)new DefaultAsyncPushConsumerFactory(this.registry), HttpVersionPolicy.FORCE_HTTP_2, h2Config, Http1Config.DEFAULT, CharCodingConfig.DEFAULT, this.sslContext));
    }

    public void start(HttpProcessor httpProcessor, Http1Config http1Config) throws IOException {
        this.start(new InternalClientH2EventHandlerFactory(httpProcessor, (HandlerFactory<AsyncPushConsumer>)new DefaultAsyncPushConsumerFactory(this.registry), HttpVersionPolicy.FORCE_HTTP_1, H2Config.DEFAULT, http1Config, CharCodingConfig.DEFAULT, this.sslContext));
    }

    public void start(H2Config h2Config) throws IOException {
        this.start(H2Processors.client(), h2Config);
    }

    public void start(Http1Config http1Config) throws IOException {
        this.start(H2Processors.client(), http1Config);
    }

    public void start() throws Exception {
        this.start(H2Config.DEFAULT);
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout, FutureCallback<ClientSessionEndpoint> callback) throws InterruptedException {
        final BasicFuture future = new BasicFuture(callback);
        this.requestSession(host, timeout, new FutureCallback<IOSession>(){

            public void completed(IOSession session) {
                future.completed((Object)new ClientSessionEndpoint(session));
            }

            public void failed(Exception cause) {
                future.failed(cause);
            }

            public void cancelled() {
                future.cancel();
            }
        });
        return future;
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, Timeout timeout) throws InterruptedException {
        return this.connect(host, timeout, null);
    }

    public Future<ClientSessionEndpoint> connect(String hostname, int port, Timeout timeout) throws InterruptedException {
        return this.connect(new HttpHost(hostname, port), timeout, null);
    }
}

