/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.benchmark;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.hc.core5.benchmark.BenchmarkConfig;
import org.apache.hc.core5.benchmark.BenchmarkWorker;
import org.apache.hc.core5.benchmark.CommandLineUtils;
import org.apache.hc.core5.benchmark.ResultFormatter;
import org.apache.hc.core5.benchmark.Results;
import org.apache.hc.core5.benchmark.Stats;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester;
import org.apache.hc.core5.http.nio.ssl.BasicClientTlsStrategy;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.frame.FramePrinter;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import org.apache.hc.core5.http2.impl.nio.bootstrap.H2AsyncRequester;
import org.apache.hc.core5.http2.impl.nio.bootstrap.H2RequesterBootstrap;
import org.apache.hc.core5.http2.protocol.H2RequestConnControl;
import org.apache.hc.core5.http2.protocol.H2RequestContent;
import org.apache.hc.core5.http2.protocol.H2RequestTargetHost;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.Timeout;

public class HttpBenchmark {
    private final BenchmarkConfig config;

    public static void main(String[] args) throws Exception {
        BenchmarkConfig config;
        Options options = CommandLineUtils.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (args.length == 0 || cmd.hasOption('h') || cmd.getArgs().length != 1) {
            CommandLineUtils.showUsage(options);
            System.exit(1);
        }
        if ((config = CommandLineUtils.parseCommandLine(cmd)).getUri() == null) {
            CommandLineUtils.showUsage(options);
            System.exit(1);
        }
        HttpBenchmark httpBenchmark = new HttpBenchmark(config);
        Results results = httpBenchmark.execute();
        System.out.println();
        ResultFormatter.print(System.out, results);
    }

    public HttpBenchmark(BenchmarkConfig config) {
        this.config = config != null ? config : BenchmarkConfig.custom().build();
    }

    public Results execute() throws Exception {
        SSLContext sslContext;
        HttpProcessorBuilder builder = HttpProcessorBuilder.create().addAll(new HttpRequestInterceptor[]{new H2RequestContent(), new H2RequestTargetHost(), new H2RequestConnControl(), new RequestUserAgent("HttpCore-AB/5.0")});
        if (this.config.isUseExpectContinue()) {
            builder.add((HttpRequestInterceptor)new RequestExpectContinue());
        }
        if ("https".equals(this.config.getUri().getScheme())) {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.setProtocol("SSL");
            if (this.config.isDisableSSLVerification()) {
                sslContextBuilder.loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                });
            } else if (this.config.getTrustStorePath() != null) {
                sslContextBuilder.loadTrustMaterial(new File(this.config.getTrustStorePath()), this.config.getTrustStorePassword() != null ? this.config.getTrustStorePassword().toCharArray() : null);
            }
            if (this.config.getIdentityStorePath() != null) {
                sslContextBuilder.loadKeyMaterial(new File(this.config.getIdentityStorePath()), this.config.getIdentityStorePassword() != null ? this.config.getIdentityStorePassword().toCharArray() : null, this.config.getIdentityStorePassword() != null ? this.config.getIdentityStorePassword().toCharArray() : null);
            }
            sslContext = sslContextBuilder.build();
        } else {
            sslContext = SSLContexts.createSystemDefault();
        }
        HttpVersionPolicy versionPolicy = this.config.isForceHttp2() ? HttpVersionPolicy.FORCE_HTTP_2 : (sslContext != null ? HttpVersionPolicy.NEGOTIATE : HttpVersionPolicy.FORCE_HTTP_1);
        final Stats stats = new Stats();
        try (H2AsyncRequester requester = H2RequesterBootstrap.bootstrap().setHttpProcessor(builder.build()).setTlsStrategy((TlsStrategy)new BasicClientTlsStrategy(sslContext)).setVersionPolicy(versionPolicy).setIOSessionDecorator((Decorator)new Decorator<IOSession>(){

            public IOSession decorate(final IOSession ioSession) {
                return new IOSession(){

                    public String getId() {
                        return ioSession.getId();
                    }

                    public Lock getLock() {
                        return ioSession.getLock();
                    }

                    public void enqueue(Command command, Command.Priority priority) {
                        ioSession.enqueue(command, priority);
                    }

                    public boolean hasCommands() {
                        return ioSession.hasCommands();
                    }

                    public Command poll() {
                        return ioSession.poll();
                    }

                    public ByteChannel channel() {
                        return ioSession.channel();
                    }

                    public SocketAddress getRemoteAddress() {
                        return ioSession.getRemoteAddress();
                    }

                    public SocketAddress getLocalAddress() {
                        return ioSession.getLocalAddress();
                    }

                    public int getEventMask() {
                        return ioSession.getEventMask();
                    }

                    public void setEventMask(int ops) {
                        ioSession.setEventMask(ops);
                    }

                    public void setEvent(int op) {
                        ioSession.setEvent(op);
                    }

                    public void clearEvent(int op) {
                        ioSession.clearEvent(op);
                    }

                    public void close() {
                        ioSession.close();
                    }

                    public int getStatus() {
                        return ioSession.getStatus();
                    }

                    public int read(ByteBuffer dst) throws IOException {
                        int bytesRead = ioSession.read(dst);
                        if (bytesRead > 0) {
                            stats.incTotalBytesRecv(bytesRead);
                        }
                        return bytesRead;
                    }

                    public int write(ByteBuffer src) throws IOException {
                        int bytesWritten = ioSession.write(src);
                        if (bytesWritten > 0) {
                            stats.incTotalBytesSent(bytesWritten);
                        }
                        return bytesWritten;
                    }

                    public boolean isOpen() {
                        return ioSession.isOpen();
                    }

                    public boolean isClosed() {
                        return ioSession.isClosed();
                    }

                    public Timeout getSocketTimeout() {
                        return ioSession.getSocketTimeout();
                    }

                    public void setSocketTimeout(Timeout timeout) {
                        ioSession.setSocketTimeout(timeout);
                    }

                    public long getLastReadTime() {
                        return ioSession.getLastReadTime();
                    }

                    public long getLastWriteTime() {
                        return ioSession.getLastWriteTime();
                    }

                    public long getLastEventTime() {
                        return ioSession.getLastEventTime();
                    }

                    public void updateReadTime() {
                        ioSession.updateReadTime();
                    }

                    public void updateWriteTime() {
                        ioSession.updateWriteTime();
                    }

                    public void close(CloseMode closeMode) {
                        ioSession.close(closeMode);
                    }

                    public IOEventHandler getHandler() {
                        return ioSession.getHandler();
                    }

                    public void upgrade(IOEventHandler handler) {
                        ioSession.upgrade(handler);
                    }
                };
            }
        }).setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
                if (HttpBenchmark.this.config.getVerbosity() >= 3) {
                    Header[] headers;
                    System.out.println(">> " + request.getMethod() + " " + request.getRequestUri());
                    for (Header header : headers = request.getHeaders()) {
                        System.out.println(">> " + header.toString());
                    }
                    System.out.println();
                }
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
                if (HttpBenchmark.this.config.getVerbosity() >= 3) {
                    Header[] headers;
                    System.out.println("<< " + response.getCode() + " " + response.getReasonPhrase());
                    for (Header header : headers = response.getHeaders()) {
                        System.out.println("<< " + header.toString());
                    }
                    System.out.println();
                }
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                if (keepAlive) {
                    stats.incKeepAliveCount();
                }
            }
        }).setStreamListener(new H2StreamListener(){
            private final FramePrinter framePrinter = new FramePrinter();

            public void onHeaderInput(HttpConnection connection, int streamId, List<? extends Header> headers) {
                if (HttpBenchmark.this.config.getVerbosity() >= 3) {
                    for (Header header : headers) {
                        System.out.println(">> " + header.toString());
                    }
                    System.out.println();
                }
            }

            public void onHeaderOutput(HttpConnection connection, int streamId, List<? extends Header> headers) {
                if (HttpBenchmark.this.config.getVerbosity() >= 3) {
                    for (Header header : headers) {
                        System.out.println("<< " + header.toString());
                    }
                    System.out.println();
                }
            }

            public void onFrameInput(HttpConnection connection, int streamId, RawFrame frame) {
                if (HttpBenchmark.this.config.getVerbosity() >= 4) {
                    System.out.print(">> ");
                    try {
                        this.framePrinter.printFrameInfo(frame, (Appendable)System.out);
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    System.out.println();
                }
            }

            public void onFrameOutput(HttpConnection connection, int streamId, RawFrame frame) {
                if (HttpBenchmark.this.config.getVerbosity() >= 4) {
                    System.out.print("<< ");
                    try {
                        this.framePrinter.printFrameInfo(frame, (Appendable)System.out);
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    System.out.println();
                }
            }

            public void onInputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
                if (HttpBenchmark.this.config.getVerbosity() >= 5) {
                    System.out.println(">> stream " + streamId + ": " + actualSize + " " + delta);
                }
            }

            public void onOutputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
                if (HttpBenchmark.this.config.getVerbosity() >= 5) {
                    System.out.println("<< stream " + streamId + ": " + actualSize + " " + delta);
                }
            }
        }).setIOReactorConfig(IOReactorConfig.custom().setSoTimeout(this.config.getSocketTimeout()).build()).create();){
            requester.setDefaultMaxPerRoute(this.config.getConcurrencyLevel());
            requester.setMaxTotal(this.config.getConcurrencyLevel() * 2);
            requester.start();
            Results results = this.doExecute((HttpAsyncRequester)requester, stats);
            return results;
        }
    }

    private Results doExecute(HttpAsyncRequester requester, Stats stats) throws Exception {
        URI requestUri = this.config.getUri();
        HttpHost host = new HttpHost(requestUri.getScheme(), requestUri.getHost(), requestUri.getPort());
        AtomicLong requestCount = new AtomicLong(this.config.getRequests());
        HttpVersion version = HttpVersion.HTTP_1_1;
        CountDownLatch completionLatch = new CountDownLatch(this.config.getConcurrencyLevel());
        BenchmarkWorker[] workers = new BenchmarkWorker[this.config.getConcurrencyLevel()];
        for (int i = 0; i < workers.length; ++i) {
            BenchmarkWorker worker;
            HttpCoreContext context = HttpCoreContext.create();
            context.setProtocolVersion((ProtocolVersion)version);
            workers[i] = worker = new BenchmarkWorker(requester, host, context, requestCount, completionLatch, stats, this.config);
        }
        long deadline = this.config.getTimeLimit() != null ? this.config.getTimeLimit().toMillis() : Long.MAX_VALUE;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < workers.length; ++i) {
            workers[i].execute();
        }
        completionLatch.await(deadline, TimeUnit.MILLISECONDS);
        if (this.config.getVerbosity() >= 3) {
            System.out.println("...done");
        }
        long endTime = System.currentTimeMillis();
        for (int i = 0; i < workers.length; ++i) {
            workers[i].releaseResources();
        }
        return new Results(stats.getServerName(), stats.getVersion(), host.getHostName(), host.getPort() > 0 ? host.getPort() : (host.getSchemeName().equalsIgnoreCase("https") ? 443 : 80), requestUri.toASCIIString(), stats.getContentLength(), this.config.getConcurrencyLevel(), endTime - startTime, stats.getSuccessCount(), stats.getFailureCount(), stats.getKeepAliveCount(), stats.getTotalBytesRecv(), stats.getTotalBytesSent(), stats.getTotalContentLength());
    }
}

