/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.CharArrayBuffer;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static void consumeQuietly(HttpEntity entity) {
        try {
            EntityUtils.consume(entity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consume(HttpEntity entity) throws IOException {
        if (entity == null) {
            return;
        }
        if (entity.isStreaming()) {
            Closer.close(entity.getContent());
        }
    }

    public static byte[] toByteArray(HttpEntity entity) throws IOException {
        Args.notNull(entity, "Entity");
        try (InputStream inStream = entity.getContent();){
            int l;
            if (inStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            int i = (int)Args.checkContentLength(entity);
            if (i < 0) {
                i = 4096;
            }
            ByteArrayBuffer buffer = new ByteArrayBuffer(i);
            byte[] tmp = new byte[4096];
            while ((l = inStream.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private static String toString(HttpEntity entity, ContentType contentType) throws IOException {
        try (InputStream inStream = entity.getContent();){
            int chReadCount;
            if (inStream == null) {
                String string = null;
                return string;
            }
            int contentLength = (int)Args.checkContentLength(entity);
            if (contentLength < 0) {
                contentLength = 4096;
            }
            Charset charset = null;
            if (contentType != null && (charset = contentType.getCharset()) == null) {
                ContentType defaultContentType = ContentType.getByMimeType(contentType.getMimeType());
                Charset charset2 = charset = defaultContentType != null ? defaultContentType.getCharset() : null;
            }
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
            InputStreamReader reader = new InputStreamReader(inStream, charset);
            CharArrayBuffer buffer = new CharArrayBuffer(contentLength);
            char[] tmp = new char[1024];
            while ((chReadCount = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, chReadCount);
            }
            String string = buffer.toString();
            return string;
        }
    }

    public static String toString(HttpEntity entity, Charset defaultCharset) throws IOException, ParseException {
        ContentType contentType;
        block5: {
            Args.notNull(entity, "Entity");
            contentType = null;
            try {
                contentType = ContentType.parse(entity.getContentType());
            }
            catch (UnsupportedCharsetException ex) {
                if (defaultCharset != null) break block5;
                throw new UnsupportedEncodingException(ex.getMessage());
            }
        }
        if (contentType != null) {
            if (contentType.getCharset() == null) {
                contentType = contentType.withCharset(defaultCharset);
            }
        } else {
            contentType = ContentType.DEFAULT_TEXT.withCharset(defaultCharset);
        }
        return EntityUtils.toString(entity, contentType);
    }

    public static String toString(HttpEntity entity, String defaultCharset) throws IOException, ParseException {
        return EntityUtils.toString(entity, defaultCharset != null ? Charset.forName(defaultCharset) : null);
    }

    public static String toString(HttpEntity entity) throws IOException, ParseException {
        Args.notNull(entity, "Entity");
        return EntityUtils.toString(entity, ContentType.parse(entity.getContentType()));
    }

    public static List<NameValuePair> parse(HttpEntity entity) throws IOException {
        CharArrayBuffer buf;
        Args.notNull(entity, "HTTP entity");
        ContentType contentType = ContentType.parse(entity.getContentType());
        if (!ContentType.APPLICATION_FORM_URLENCODED.isSameMimeType(contentType)) {
            return Collections.emptyList();
        }
        long len = entity.getContentLength();
        Args.checkRange(len, 0L, Integer.MAX_VALUE, "HTTP entity is too large");
        Charset charset = contentType.getCharset() != null ? contentType.getCharset() : StandardCharsets.ISO_8859_1;
        try (InputStream inStream = entity.getContent();){
            int l;
            if (inStream == null) {
                List<NameValuePair> list = Collections.emptyList();
                return list;
            }
            buf = new CharArrayBuffer(len > 0L ? (int)len : 1024);
            InputStreamReader reader = new InputStreamReader(inStream, charset);
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buf.append(tmp, 0, l);
            }
        }
        if (buf.isEmpty()) {
            return Collections.emptyList();
        }
        return URLEncodedUtils.parse(buf, charset, '&');
    }
}

