/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.nio;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.NotImplementedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.UnsupportedHttpVersionException;
import org.apache.hc.core5.http.nio.AsyncResponseProducer;
import org.apache.hc.core5.http.nio.support.BasicResponseProducer;

@Internal
public class ServerSupport {
    public static void validateResponse(HttpResponse response, EntityDetails responseEntityDetails) throws HttpException {
        int status = response.getCode();
        switch (status) {
            case 204: 
            case 304: {
                if (responseEntityDetails == null) break;
                throw new HttpException("Response " + status + " must not enclose an entity");
            }
        }
    }

    public static AsyncResponseProducer handleException(Exception ex) {
        String message = ex.getMessage();
        if (message == null) {
            message = ex.toString();
        }
        return new BasicResponseProducer(ServerSupport.toStatusCode(ex), message);
    }

    public static int toStatusCode(Exception ex) {
        int code = ex instanceof MethodNotSupportedException ? 501 : (ex instanceof UnsupportedHttpVersionException ? 505 : (ex instanceof NotImplementedException ? 501 : (ex instanceof ProtocolException ? 400 : 500)));
        return code;
    }
}

