/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

public abstract class AbstractAsyncResponseConsumer<T, E>
implements AsyncResponseConsumer<T> {
    private final AsyncEntityConsumer<E> entityConsumer;
    private final AtomicReference<T> resultRef;
    private final AtomicReference<Exception> exceptionRef;

    public AbstractAsyncResponseConsumer(AsyncEntityConsumer<E> entityConsumer) {
        Args.notNull(entityConsumer, "Entity consumer");
        this.entityConsumer = entityConsumer;
        this.resultRef = new AtomicReference<Object>(null);
        this.exceptionRef = new AtomicReference<Object>(null);
    }

    protected abstract T buildResult(HttpResponse var1, E var2, ContentType var3);

    @Override
    public final void consumeResponse(final HttpResponse response, final EntityDetails entityDetails, HttpContext httpContext, final FutureCallback<T> resultCallback) throws HttpException, IOException {
        if (entityDetails != null) {
            this.entityConsumer.streamStart(entityDetails, new FutureCallback<E>(){

                @Override
                public void completed(E entity) {
                    block3: {
                        try {
                            ContentType contentType = ContentType.parse(entityDetails.getContentType());
                            Object result = AbstractAsyncResponseConsumer.this.buildResult(response, entity, contentType);
                            AbstractAsyncResponseConsumer.this.resultRef.compareAndSet(null, result);
                            if (resultCallback != null) {
                                resultCallback.completed(result);
                            }
                        }
                        catch (UnsupportedCharsetException ex) {
                            AbstractAsyncResponseConsumer.this.exceptionRef.compareAndSet(null, ex);
                            if (resultCallback == null) break block3;
                            resultCallback.failed(ex);
                        }
                    }
                }

                @Override
                public void failed(Exception ex) {
                    AbstractAsyncResponseConsumer.this.exceptionRef.compareAndSet(null, ex);
                    if (resultCallback != null) {
                        resultCallback.failed(ex);
                    }
                }

                @Override
                public void cancelled() {
                    if (resultCallback != null) {
                        resultCallback.cancelled();
                    }
                }
            });
        } else {
            T result = this.buildResult(response, null, null);
            this.resultRef.compareAndSet(null, result);
            if (resultCallback != null) {
                resultCallback.completed(result);
            }
            this.entityConsumer.releaseResources();
        }
    }

    @Override
    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.entityConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public final void consume(ByteBuffer src) throws IOException {
        this.entityConsumer.consume(src);
    }

    @Override
    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.entityConsumer.streamEnd(trailers);
    }

    @Override
    public T getResult() {
        return this.resultRef.get();
    }

    public Exception getException() {
        return this.exceptionRef.get();
    }

    @Override
    public final void failed(Exception cause) {
        this.exceptionRef.compareAndSet(null, cause);
        this.releaseResources();
    }

    @Override
    public final void releaseResources() {
        this.entityConsumer.releaseResources();
    }
}

