/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.nio.pool;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.DefaultAddressResolver;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.AbstractIOSessionPool;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE)
public final class H2ConnPool
extends AbstractIOSessionPool<HttpHost> {
    private final ConnectionInitiator connectionInitiator;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;
    private final TlsStrategy tlsStrategy;
    private volatile TimeValue validateAfterInactivity;

    public H2ConnPool(ConnectionInitiator connectionInitiator, Resolver<HttpHost, InetSocketAddress> addressResolver, TlsStrategy tlsStrategy) {
        this.connectionInitiator = (ConnectionInitiator)Args.notNull((Object)connectionInitiator, (String)"Connection initiator");
        this.addressResolver = addressResolver != null ? addressResolver : DefaultAddressResolver.INSTANCE;
        this.tlsStrategy = tlsStrategy;
    }

    public TimeValue getValidateAfterInactivity() {
        return this.validateAfterInactivity;
    }

    public void setValidateAfterInactivity(TimeValue timeValue) {
        this.validateAfterInactivity = timeValue;
    }

    protected void closeSession(IOSession ioSession, CloseMode closeMode) {
        if (closeMode == CloseMode.GRACEFUL) {
            ioSession.enqueue((Command)ShutdownCommand.GRACEFUL, Command.Priority.NORMAL);
        } else {
            ioSession.close(closeMode);
        }
    }

    protected Future<IOSession> connectSession(final HttpHost namedEndpoint, final Timeout requestTimeout, final FutureCallback<IOSession> callback) {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.addressResolver.resolve((Object)namedEndpoint);
        return this.connectionInitiator.connect((NamedEndpoint)namedEndpoint, (SocketAddress)remoteAddress, null, requestTimeout, null, (FutureCallback)new FutureCallback<IOSession>(){

            public void completed(IOSession ioSession) {
                if (H2ConnPool.this.tlsStrategy != null && URIScheme.HTTPS.same(namedEndpoint.getSchemeName()) && ioSession instanceof TransportSecurityLayer) {
                    H2ConnPool.this.tlsStrategy.upgrade((TransportSecurityLayer)ioSession, namedEndpoint, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), null);
                    ioSession.setSocketTimeout(requestTimeout);
                }
                callback.completed((Object)ioSession);
            }

            public void failed(Exception ex) {
                callback.failed(ex);
            }

            public void cancelled() {
                callback.cancelled();
            }
        });
    }

    protected void validateSession(final IOSession ioSession, final Callback<Boolean> callback) {
        long lastAccessTime;
        long deadline;
        TimeValue timeValue = this.validateAfterInactivity;
        if (TimeValue.isPositive((TimeValue)timeValue) && (deadline = (lastAccessTime = Math.min(ioSession.getLastReadTime(), ioSession.getLastWriteTime())) + timeValue.toMillis()) <= System.currentTimeMillis()) {
            final Timeout socketTimeoutMillis = ioSession.getSocketTimeout();
            ioSession.enqueue((Command)new PingCommand(new BasicPingHandler(new Callback<Boolean>(){

                public void execute(Boolean result) {
                    ioSession.setSocketTimeout(socketTimeoutMillis);
                    callback.execute((Object)result);
                }
            })), Command.Priority.NORMAL);
            return;
        }
        callback.execute((Object)true);
    }
}

