/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.util.Date;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ExceptionEvent {
    private final Throwable ex;
    private final long time;

    public ExceptionEvent(Throwable ex, Date timestamp) {
        this.ex = ex;
        this.time = timestamp != null ? timestamp.getTime() : 0L;
    }

    public ExceptionEvent(Exception ex) {
        this(ex, new Date());
    }

    public Throwable getCause() {
        return this.ex;
    }

    public Date getTimestamp() {
        return new Date(this.time);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(new Date(this.time));
        buffer.append(" ");
        buffer.append(this.ex);
        return buffer.toString();
    }
}

