/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import org.apache.hc.core5.http2.impl.nio.ServerHttp2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ServerHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ServerHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.ssl.ApplicationProtocols;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Internal
public class ServerHttpProtocolNegotiator
implements HttpConnectionEventHandler {
    static final byte[] PREFACE = ClientHttpProtocolNegotiator.PREFACE;
    private final ProtocolIOSession ioSession;
    private final ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ServerHttp2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final ByteBuffer bytebuf;
    private volatile boolean expectValidH2Preface;

    public ServerHttpProtocolNegotiator(ProtocolIOSession ioSession, ServerHttp1StreamDuplexerFactory http1StreamHandlerFactory, ServerHttp2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy) {
        this.ioSession = Args.notNull(ioSession, "I/O session");
        this.http1StreamHandlerFactory = Args.notNull(http1StreamHandlerFactory, "HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.bytebuf = ByteBuffer.allocate(1024);
    }

    @Override
    public void connected(IOSession session) {
        try {
            TlsDetails tlsDetails = this.ioSession.getTlsDetails();
            switch (this.versionPolicy) {
                case NEGOTIATE: {
                    if (tlsDetails == null || !ApplicationProtocols.HTTP_2.id.equals(tlsDetails.getApplicationProtocol())) break;
                    this.expectValidH2Preface = true;
                    break;
                }
                case FORCE_HTTP_2: {
                    if (tlsDetails != null && ApplicationProtocols.HTTP_1_1.id.equals(tlsDetails.getApplicationProtocol())) break;
                    this.expectValidH2Preface = true;
                    break;
                }
                case FORCE_HTTP_1: {
                    ServerHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(tlsDetails != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, this.ioSession);
                    this.ioSession.upgrade(new ServerHttp1IOEventHandler(http1StreamHandler));
                    http1StreamHandler.onConnect(null);
                }
            }
        }
        catch (Exception ex) {
            this.exception(session, ex);
        }
    }

    @Override
    public void inputReady(IOSession session) {
        try {
            int bytesRead;
            boolean endOfStream = false;
            if (this.bytebuf.position() < PREFACE.length && (bytesRead = session.channel().read(this.bytebuf)) == -1) {
                endOfStream = true;
            }
            if (this.bytebuf.position() >= PREFACE.length) {
                this.bytebuf.flip();
                boolean validH2Preface = true;
                for (int i = 0; i < PREFACE.length; ++i) {
                    if (this.bytebuf.get() == PREFACE[i]) continue;
                    if (this.expectValidH2Preface) {
                        throw new HttpException("Unexpected HTTP/2 preface");
                    }
                    validH2Preface = false;
                }
                if (validH2Preface) {
                    ServerHttp2StreamMultiplexer http2StreamHandler = this.http2StreamHandlerFactory.create(this.ioSession);
                    this.ioSession.upgrade(new ServerHttp2IOEventHandler(http2StreamHandler));
                    http2StreamHandler.onConnect(this.bytebuf.hasRemaining() ? this.bytebuf : null);
                    http2StreamHandler.onInput();
                } else {
                    TlsDetails tlsDetails = this.ioSession.getTlsDetails();
                    ServerHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(tlsDetails != null ? URIScheme.HTTPS.id : URIScheme.HTTP.id, this.ioSession);
                    this.ioSession.upgrade(new ServerHttp1IOEventHandler(http1StreamHandler));
                    this.bytebuf.rewind();
                    http1StreamHandler.onConnect(this.bytebuf);
                    http1StreamHandler.onInput();
                }
            } else if (endOfStream) {
                throw new ConnectionClosedException();
            }
        }
        catch (Exception ex) {
            this.exception(session, ex);
        }
    }

    @Override
    public void outputReady(IOSession session) {
    }

    @Override
    public void timeout(IOSession session, Timeout timeout) {
        this.exception(session, SocketTimeoutExceptionFactory.create(timeout));
    }

    @Override
    public void exception(IOSession session, Exception cause) {
        session.close(CloseMode.IMMEDIATE);
    }

    @Override
    public void disconnected(IOSession session) {
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return null;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return !this.ioSession.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.ioSession.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }
}

