/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpStreamResetException;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.BasicEndpointDetails;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.impl.CharCodingSupport;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.ExecutableCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2StreamResetException;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.config.H2Param;
import org.apache.hc.core5.http2.config.H2Setting;
import org.apache.hc.core5.http2.frame.FrameFactory;
import org.apache.hc.core5.http2.frame.FrameFlag;
import org.apache.hc.core5.http2.frame.FrameType;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.hpack.HPackDecoder;
import org.apache.hc.core5.http2.hpack.HPackEncoder;
import org.apache.hc.core5.http2.impl.BasicH2TransportMetrics;
import org.apache.hc.core5.http2.impl.nio.FrameInputBuffer;
import org.apache.hc.core5.http2.impl.nio.FrameOutputBuffer;
import org.apache.hc.core5.http2.impl.nio.Http2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.Http2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.Http2StreamListener;
import org.apache.hc.core5.http2.impl.nio.ServerPushHttp2StreamHandler;
import org.apache.hc.core5.http2.nio.AsyncPingHandler;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.Timeout;

abstract class AbstractHttp2StreamMultiplexer
implements Identifiable,
HttpConnection {
    private static final long LINGER_TIME = 1000L;
    private final ProtocolIOSession ioSession;
    private final FrameFactory frameFactory;
    private final StreamIdGenerator idGenerator;
    private final HttpProcessor httpProcessor;
    private final H2Config localConfig;
    private final BasicH2TransportMetrics inputMetrics;
    private final BasicH2TransportMetrics outputMetrics;
    private final BasicHttpConnectionMetrics connMetrics;
    private final FrameInputBuffer inputBuffer;
    private final FrameOutputBuffer outputBuffer;
    private final Deque<RawFrame> outputQueue;
    private final HPackEncoder hPackEncoder;
    private final HPackDecoder hPackDecoder;
    private final Map<Integer, Http2Stream> streamMap;
    private final Queue<AsyncPingHandler> pingHandlers;
    private final AtomicInteger connInputWindow;
    private final AtomicInteger connOutputWindow;
    private final Lock outputLock;
    private final AtomicInteger outputRequests;
    private final AtomicInteger lastStreamId;
    private final Http2StreamListener streamListener;
    private ConnectionHandshake connState = ConnectionHandshake.READY;
    private SettingsHandshake localSettingState = SettingsHandshake.READY;
    private SettingsHandshake remoteSettingState = SettingsHandshake.READY;
    private H2Config remoteConfig;
    private int lowMark;
    private Continuation continuation;
    private int processedRemoteStreamId;
    private EndpointDetails endpointDetails;

    AbstractHttp2StreamMultiplexer(ProtocolIOSession ioSession, FrameFactory frameFactory, StreamIdGenerator idGenerator, HttpProcessor httpProcessor, CharCodingConfig charCodingConfig, H2Config h2Config, Http2StreamListener streamListener) {
        this.ioSession = Args.notNull(ioSession, "IO session");
        this.frameFactory = Args.notNull(frameFactory, "Frame factory");
        this.idGenerator = Args.notNull(idGenerator, "Stream id generator");
        this.httpProcessor = Args.notNull(httpProcessor, "HTTP processor");
        this.localConfig = h2Config != null ? h2Config : H2Config.DEFAULT;
        this.inputMetrics = new BasicH2TransportMetrics();
        this.outputMetrics = new BasicH2TransportMetrics();
        this.connMetrics = new BasicHttpConnectionMetrics(this.inputMetrics, this.outputMetrics);
        this.inputBuffer = new FrameInputBuffer(this.inputMetrics, this.localConfig.getMaxFrameSize());
        this.outputBuffer = new FrameOutputBuffer(this.outputMetrics, this.localConfig.getMaxFrameSize());
        this.outputQueue = new ConcurrentLinkedDeque<RawFrame>();
        this.pingHandlers = new ConcurrentLinkedQueue<AsyncPingHandler>();
        this.outputLock = new ReentrantLock();
        this.outputRequests = new AtomicInteger(0);
        this.lastStreamId = new AtomicInteger(0);
        this.hPackEncoder = new HPackEncoder(CharCodingSupport.createEncoder(charCodingConfig));
        this.hPackDecoder = new HPackDecoder(CharCodingSupport.createDecoder(charCodingConfig));
        this.streamMap = new ConcurrentHashMap<Integer, Http2Stream>();
        this.connInputWindow = new AtomicInteger(this.localConfig.getInitialWindowSize());
        this.connOutputWindow = new AtomicInteger(H2Config.DEFAULT.getInitialWindowSize());
        this.hPackDecoder.setMaxTableSize(H2Config.DEFAULT.getInitialWindowSize());
        this.hPackEncoder.setMaxTableSize(this.localConfig.getHeaderTableSize());
        this.remoteConfig = H2Config.DEFAULT;
        this.lowMark = this.remoteConfig.getInitialWindowSize() / 2;
        this.streamListener = streamListener;
    }

    @Override
    public String getId() {
        return this.ioSession.getId();
    }

    abstract void acceptHeaderFrame() throws H2ConnectionException;

    abstract void acceptPushRequest() throws H2ConnectionException;

    abstract void acceptPushFrame() throws H2ConnectionException;

    abstract Http2StreamHandler createRemotelyInitiatedStream(Http2StreamChannel var1, HttpProcessor var2, BasicHttpConnectionMetrics var3, HandlerFactory<AsyncPushConsumer> var4) throws IOException;

    abstract Http2StreamHandler createLocallyInitiatedStream(ExecutableCommand var1, Http2StreamChannel var2, HttpProcessor var3, BasicHttpConnectionMetrics var4) throws IOException;

    private int updateWindow(AtomicInteger window, int delta) throws ArithmeticException {
        long newValue;
        int current;
        do {
            if ((newValue = (long)(current = window.get()) + (long)delta) == 0x80000000L) {
                newValue = Integer.MAX_VALUE;
            }
            if (Math.abs(newValue) <= Integer.MAX_VALUE) continue;
            throw new ArithmeticException("Update causes flow control window to exceed 2147483647");
        } while (!window.compareAndSet(current, (int)newValue));
        return (int)newValue;
    }

    private int updateInputWindow(int streamId, AtomicInteger window, int delta) throws ArithmeticException {
        int newSize = this.updateWindow(window, delta);
        if (this.streamListener != null) {
            this.streamListener.onInputFlowControl(this, streamId, delta, newSize);
        }
        return newSize;
    }

    private int updateOutputWindow(int streamId, AtomicInteger window, int delta) throws ArithmeticException {
        int newSize = this.updateWindow(window, delta);
        if (this.streamListener != null) {
            this.streamListener.onOutputFlowControl(this, streamId, delta, newSize);
        }
        return newSize;
    }

    private void commitFrameInternal(RawFrame frame) throws IOException {
        if (this.outputBuffer.isEmpty() && this.outputQueue.isEmpty()) {
            if (this.streamListener != null) {
                this.streamListener.onFrameOutput(this, frame.getStreamId(), frame);
            }
            this.outputBuffer.write(frame, this.ioSession.channel());
        } else {
            this.outputQueue.addLast(frame);
        }
        this.ioSession.setEvent(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitFrame(RawFrame frame) throws IOException {
        Args.notNull(frame, "Frame");
        this.outputLock.lock();
        try {
            this.commitFrameInternal(frame);
        }
        finally {
            this.outputLock.unlock();
        }
    }

    private void commitHeaders(int streamId, List<? extends Header> headers, boolean endStream) throws IOException {
        if (this.streamListener != null) {
            this.streamListener.onHeaderOutput(this, streamId, headers);
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(512);
        this.hPackEncoder.encodeHeaders(buf, headers);
        int off = 0;
        int remaining = buf.length();
        boolean continuation = false;
        while (remaining > 0) {
            RawFrame frame;
            boolean endHeaders;
            int chunk = Math.min(this.remoteConfig.getMaxFrameSize(), remaining);
            ByteBuffer payload = ByteBuffer.wrap(buf.array(), off, chunk);
            off += chunk;
            boolean bl = endHeaders = (remaining -= chunk) == 0;
            if (!continuation) {
                frame = this.frameFactory.createHeaders(streamId, payload, endHeaders, endStream);
                continuation = true;
            } else {
                frame = this.frameFactory.createContinuation(streamId, payload, endHeaders);
            }
            this.commitFrameInternal(frame);
        }
    }

    private void commitPushPromise(int streamId, int promisedStreamId, List<Header> headers) throws IOException {
        if (headers == null || headers.isEmpty()) {
            throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Message headers are missing");
        }
        if (this.streamListener != null) {
            this.streamListener.onHeaderOutput(this, streamId, headers);
        }
        ByteArrayBuffer buf = new ByteArrayBuffer(512);
        buf.append((byte)(promisedStreamId >> 24));
        buf.append((byte)(promisedStreamId >> 16));
        buf.append((byte)(promisedStreamId >> 8));
        buf.append((byte)promisedStreamId);
        this.hPackEncoder.encodeHeaders(buf, headers);
        int off = 0;
        int remaining = buf.length();
        boolean continuation = false;
        while (remaining > 0) {
            RawFrame frame;
            boolean endHeaders;
            int chunk = Math.min(this.remoteConfig.getMaxFrameSize(), remaining);
            ByteBuffer payload = ByteBuffer.wrap(buf.array(), off, chunk);
            off += chunk;
            boolean bl = endHeaders = (remaining -= chunk) == 0;
            if (!continuation) {
                frame = this.frameFactory.createPushPromise(streamId, payload, endHeaders);
                continuation = true;
            } else {
                frame = this.frameFactory.createContinuation(streamId, payload, endHeaders);
            }
            this.commitFrameInternal(frame);
        }
    }

    private void streamDataFrame(int streamId, AtomicInteger streamOutputWindow, ByteBuffer payload, int chunk) throws IOException {
        RawFrame dataFrame = this.frameFactory.createData(streamId, payload, false);
        if (this.streamListener != null) {
            this.streamListener.onFrameOutput(this, streamId, dataFrame);
        }
        this.updateOutputWindow(0, this.connOutputWindow, -chunk);
        this.updateOutputWindow(streamId, streamOutputWindow, -chunk);
        this.outputBuffer.write(dataFrame, this.ioSession.channel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int streamData(int streamId, AtomicInteger streamOutputWindow, ByteBuffer payload) throws IOException {
        if (this.outputBuffer.isEmpty() && this.outputQueue.isEmpty()) {
            int chunk;
            int capacity = Math.min(this.connOutputWindow.get(), streamOutputWindow.get());
            if (capacity <= 0) {
                return 0;
            }
            int frameSize = Math.max(this.localConfig.getMaxFrameSize(), this.remoteConfig.getMaxFrameSize());
            int maxPayloadSize = Math.min(capacity, frameSize);
            if (payload.remaining() <= maxPayloadSize) {
                chunk = payload.remaining();
                this.streamDataFrame(streamId, streamOutputWindow, payload, chunk);
            } else {
                chunk = maxPayloadSize;
                int originalLimit = payload.limit();
                try {
                    payload.limit(payload.position() + chunk);
                    this.streamDataFrame(streamId, streamOutputWindow, payload, chunk);
                }
                finally {
                    payload.limit(originalLimit);
                }
            }
            payload.position(payload.position() + chunk);
            this.ioSession.setEvent(4);
            return chunk;
        }
        return 0;
    }

    private void incrementInputCapacity(int streamId, AtomicInteger inputWindow, int inputCapacity) throws IOException {
        if (inputCapacity > 0) {
            int streamWinSize = inputWindow.get();
            int remainingCapacity = Integer.MAX_VALUE - streamWinSize;
            int chunk = Math.min(inputCapacity, remainingCapacity);
            RawFrame windowUpdateFrame = this.frameFactory.createWindowUpdate(streamId, chunk);
            this.commitFrame(windowUpdateFrame);
            this.updateInputWindow(streamId, inputWindow, chunk);
        }
    }

    private void requestSessionOutput() {
        this.outputRequests.incrementAndGet();
        this.ioSession.setEvent(4);
    }

    private void updateLastStreamId(int streamId) {
        int currentId = this.lastStreamId.get();
        if (streamId > currentId) {
            this.lastStreamId.compareAndSet(currentId, streamId);
        }
    }

    private int generateStreamId() {
        int newStreamId;
        int currentId;
        while (!this.lastStreamId.compareAndSet(currentId = this.lastStreamId.get(), newStreamId = this.idGenerator.generate(currentId))) {
        }
        return newStreamId;
    }

    public final void onConnect(ByteBuffer prefeed) throws HttpException, IOException {
        if (prefeed != null) {
            this.inputBuffer.put(prefeed);
        }
        this.connState = ConnectionHandshake.ACTIVE;
        RawFrame settingsFrame = this.frameFactory.createSettings(new H2Setting(H2Param.HEADER_TABLE_SIZE, this.localConfig.getHeaderTableSize()), new H2Setting(H2Param.ENABLE_PUSH, this.localConfig.isPushEnabled() ? 1 : 0), new H2Setting(H2Param.MAX_CONCURRENT_STREAMS, this.localConfig.getMaxConcurrentStreams()), new H2Setting(H2Param.INITIAL_WINDOW_SIZE, this.localConfig.getInitialWindowSize()), new H2Setting(H2Param.MAX_FRAME_SIZE, this.localConfig.getMaxFrameSize()), new H2Setting(H2Param.MAX_HEADER_LIST_SIZE, this.localConfig.getMaxHeaderListSize()));
        this.commitFrame(settingsFrame);
        this.localSettingState = SettingsHandshake.TRANSMITTED;
    }

    public final void onInput() throws HttpException, IOException {
        if (this.connState == ConnectionHandshake.SHUTDOWN) {
            this.ioSession.clearEvent(1);
        } else {
            RawFrame frame;
            while ((frame = this.inputBuffer.read(this.ioSession.channel())) != null) {
                if (this.streamListener != null) {
                    this.streamListener.onFrameInput(this, frame.getStreamId(), frame);
                }
                this.consumeFrame(frame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onOutput() throws HttpException, IOException {
        int delta;
        this.outputLock.lock();
        try {
            RawFrame frame;
            if (!this.outputBuffer.isEmpty()) {
                this.outputBuffer.flush(this.ioSession.channel());
            }
            while (this.outputBuffer.isEmpty() && (frame = this.outputQueue.poll()) != null) {
                if (this.streamListener != null) {
                    this.streamListener.onFrameOutput(this, frame.getStreamId(), frame);
                }
                this.outputBuffer.write(frame, this.ioSession.channel());
            }
        }
        finally {
            this.outputLock.unlock();
        }
        int connWinSize = this.connInputWindow.get();
        if (connWinSize < this.lowMark && (delta = this.remoteConfig.getInitialWindowSize() - connWinSize) > 0) {
            RawFrame windowUpdateFrame = this.frameFactory.createWindowUpdate(0, delta);
            this.commitFrame(windowUpdateFrame);
            this.updateInputWindow(0, this.connInputWindow, delta);
        }
        if (this.connState.compareTo(ConnectionHandshake.SHUTDOWN) < 0) {
            if (this.connOutputWindow.get() > 0 && this.remoteSettingState == SettingsHandshake.ACKED) {
                this.produceOutput();
            }
            int pendingOutputRequests = this.outputRequests.get();
            boolean outputPending = false;
            if (!this.streamMap.isEmpty() && this.connOutputWindow.get() > 0) {
                for (Map.Entry<Integer, Http2Stream> entry : this.streamMap.entrySet()) {
                    Http2Stream stream = entry.getValue();
                    if (stream.isLocalClosed() || stream.getOutputWindow().get() <= 0 || !stream.isOutputReady()) continue;
                    outputPending = true;
                    break;
                }
            }
            if (!outputPending) {
                this.outputLock.lock();
                try {
                    if (!this.outputBuffer.isEmpty() || !this.outputQueue.isEmpty()) {
                        outputPending = true;
                    }
                }
                finally {
                    this.outputLock.unlock();
                }
            }
            if (!outputPending && this.outputRequests.compareAndSet(pendingOutputRequests, 0)) {
                this.ioSession.clearEvent(4);
            } else {
                this.outputRequests.addAndGet(-pendingOutputRequests);
            }
        }
        if (this.connState.compareTo(ConnectionHandshake.ACTIVE) <= 0 && this.remoteSettingState == SettingsHandshake.ACKED) {
            this.processPendingCommands();
        }
        if (this.connState.compareTo(ConnectionHandshake.GRACEFUL_SHUTDOWN) == 0) {
            Iterator<Map.Entry<Integer, Http2Stream>> it = this.streamMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Http2Stream> entry = it.next();
                Http2Stream stream = entry.getValue();
                if (!stream.isLocalClosed() || !stream.isRemoteClosed()) continue;
                stream.releaseResources();
                it.remove();
            }
            if (this.streamMap.isEmpty()) {
                this.connState = ConnectionHandshake.SHUTDOWN;
            }
        }
        if (this.connState.compareTo(ConnectionHandshake.SHUTDOWN) >= 0) {
            this.outputLock.lock();
            try {
                if (this.outputBuffer.isEmpty() && this.outputQueue.isEmpty()) {
                    this.ioSession.close();
                }
            }
            finally {
                this.outputLock.unlock();
            }
        }
    }

    public final void onTimeout(Timeout timeout) throws HttpException, IOException {
        this.connState = ConnectionHandshake.SHUTDOWN;
        RawFrame goAway = this.localSettingState != SettingsHandshake.ACKED ? this.frameFactory.createGoAway(this.processedRemoteStreamId, H2Error.SETTINGS_TIMEOUT, "Setting timeout (" + timeout + ")") : this.frameFactory.createGoAway(this.processedRemoteStreamId, H2Error.NO_ERROR, "Timeout due to inactivity (" + timeout + ")");
        this.commitFrame(goAway);
        for (Map.Entry<Integer, Http2Stream> entry : this.streamMap.entrySet()) {
            Http2Stream stream = entry.getValue();
            stream.reset(new H2StreamResetException(H2Error.NO_ERROR, "Timeout due to inactivity (" + timeout + ")"));
        }
        this.streamMap.clear();
    }

    public final void onDisconnect() {
        Command command;
        AsyncPingHandler pingHandler;
        while ((pingHandler = this.pingHandlers.poll()) != null) {
            pingHandler.cancel();
        }
        for (Map.Entry<Integer, Http2Stream> entry : this.streamMap.entrySet()) {
            Http2Stream stream = entry.getValue();
            stream.cancel();
        }
        while ((command = this.ioSession.poll()) != null) {
            if (command instanceof ExecutableCommand) {
                ((ExecutableCommand)command).failed(new ConnectionClosedException());
                continue;
            }
            command.cancel();
        }
    }

    private void processPendingCommands() throws IOException, HttpException {
        Command command;
        while (this.streamMap.size() < this.remoteConfig.getMaxConcurrentStreams() && (command = this.ioSession.poll()) != null) {
            CancellableDependency cancellableDependency;
            if (command instanceof ShutdownCommand) {
                ShutdownCommand shutdownCommand = (ShutdownCommand)command;
                if (shutdownCommand.getType() == CloseMode.IMMEDIATE) {
                    for (Map.Entry<Integer, Http2Stream> entry : this.streamMap.entrySet()) {
                        Http2Stream stream = entry.getValue();
                        stream.cancel();
                    }
                    this.streamMap.clear();
                    this.connState = ConnectionHandshake.SHUTDOWN;
                    break;
                }
                if (this.connState.compareTo(ConnectionHandshake.ACTIVE) > 0) break;
                RawFrame goAway = this.frameFactory.createGoAway(this.processedRemoteStreamId, H2Error.NO_ERROR, "Graceful shutdown");
                this.commitFrame(goAway);
                this.connState = this.streamMap.isEmpty() ? ConnectionHandshake.SHUTDOWN : ConnectionHandshake.GRACEFUL_SHUTDOWN;
                break;
            }
            if (command instanceof PingCommand) {
                PingCommand pingCommand = (PingCommand)command;
                AsyncPingHandler handler = pingCommand.getHandler();
                this.pingHandlers.add(handler);
                RawFrame ping = this.frameFactory.createPing(handler.getData());
                this.commitFrame(ping);
                continue;
            }
            if (!(command instanceof ExecutableCommand)) continue;
            int streamId = this.generateStreamId();
            Http2StreamChannelImpl channel = new Http2StreamChannelImpl(streamId, true, this.localConfig.getInitialWindowSize(), this.remoteConfig.getInitialWindowSize());
            ExecutableCommand executableCommand = (ExecutableCommand)command;
            Http2StreamHandler streamHandler = this.createLocallyInitiatedStream(executableCommand, channel, this.httpProcessor, this.connMetrics);
            final Http2Stream stream = new Http2Stream(channel, streamHandler, false);
            this.streamMap.put(streamId, stream);
            if (stream.isOutputReady()) {
                stream.produceOutput();
            }
            if ((cancellableDependency = executableCommand.getCancellableDependency()) != null) {
                cancellableDependency.setDependency(new Cancellable(){

                    @Override
                    public boolean cancel() {
                        return stream.abort();
                    }
                });
            }
            if (this.outputQueue.isEmpty()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onException(Exception cause) {
        try {
            Command command;
            AsyncPingHandler pingHandler;
            while ((pingHandler = this.pingHandlers.poll()) != null) {
                pingHandler.failed(cause);
            }
            while ((command = this.ioSession.poll()) != null) {
                if (command instanceof ExecutableCommand) {
                    ((ExecutableCommand)command).failed(new ConnectionClosedException());
                    continue;
                }
                command.cancel();
            }
            for (Map.Entry<Integer, Http2Stream> entry : this.streamMap.entrySet()) {
                Http2Stream stream = entry.getValue();
                if (stream.isLocalClosed() && (stream.isRemoteClosed() || stream.isLocalReset())) {
                    stream.reset(cause);
                }
                stream.releaseResources();
            }
            this.streamMap.clear();
            if (!(cause instanceof ConnectionClosedException) && this.connState.compareTo(ConnectionHandshake.GRACEFUL_SHUTDOWN) <= 0) {
                H2Error errorCode = cause instanceof H2ConnectionException ? H2Error.getByCode(((H2ConnectionException)cause).getCode()) : (cause instanceof ProtocolException ? H2Error.PROTOCOL_ERROR : H2Error.INTERNAL_ERROR);
                RawFrame goAway = this.frameFactory.createGoAway(this.processedRemoteStreamId, errorCode, cause.getMessage());
                this.commitFrame(goAway);
            }
            this.connState = ConnectionHandshake.SHUTDOWN;
        }
        catch (IOException iOException) {
        }
        finally {
            this.ioSession.close(CloseMode.IMMEDIATE);
        }
    }

    private Http2Stream getValidStream(int streamId) throws H2ConnectionException {
        if (streamId == 0) {
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + streamId);
        }
        Http2Stream stream = this.streamMap.get(streamId);
        if (stream == null) {
            if (streamId <= this.lastStreamId.get()) {
                throw new H2ConnectionException(H2Error.STREAM_CLOSED, "Stream closed");
            }
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected stream id: " + streamId);
        }
        return stream;
    }

    private void consumeFrame(RawFrame frame) throws HttpException, IOException {
        FrameType frameType = FrameType.valueOf(frame.getType());
        int streamId = frame.getStreamId();
        if (this.continuation != null && frameType != FrameType.CONTINUATION) {
            throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "CONTINUATION frame expected");
        }
        if (this.connState.compareTo(ConnectionHandshake.GRACEFUL_SHUTDOWN) >= 0 && streamId > this.processedRemoteStreamId && !this.idGenerator.isSameSide(streamId)) {
            return;
        }
        switch (frameType) {
            case DATA: {
                Http2Stream stream = this.getValidStream(streamId);
                try {
                    this.consumeDataFrame(frame, stream);
                }
                catch (H2StreamResetException ex) {
                    stream.localReset(ex);
                }
                catch (HttpStreamResetException ex) {
                    stream.localReset((Exception)ex, ex.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.CANCEL);
                }
                if (!stream.isTerminated()) break;
                this.streamMap.remove(streamId);
                stream.releaseResources();
                break;
            }
            case HEADERS: {
                if (streamId == 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + streamId);
                }
                Http2Stream stream = this.streamMap.get(streamId);
                if (stream == null) {
                    this.acceptHeaderFrame();
                    this.updateLastStreamId(streamId);
                    Http2StreamChannelImpl channel = new Http2StreamChannelImpl(streamId, false, this.localConfig.getInitialWindowSize(), this.remoteConfig.getInitialWindowSize());
                    Http2StreamHandler streamHandler = this.createRemotelyInitiatedStream(channel, this.httpProcessor, this.connMetrics, null);
                    stream = new Http2Stream(channel, streamHandler, true);
                    if (stream.isOutputReady()) {
                        stream.produceOutput();
                    }
                    this.streamMap.put(streamId, stream);
                }
                try {
                    this.consumeHeaderFrame(frame, stream);
                    if (stream.isOutputReady()) {
                        stream.produceOutput();
                    }
                }
                catch (H2StreamResetException ex) {
                    stream.localReset(ex);
                }
                catch (HttpStreamResetException ex) {
                    stream.localReset((Exception)ex, ex.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.CANCEL);
                }
                if (!stream.isTerminated()) break;
                this.streamMap.remove(streamId);
                stream.releaseResources();
                break;
            }
            case CONTINUATION: {
                if (this.continuation == null) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected CONTINUATION frame");
                }
                if (streamId != this.continuation.streamId) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected CONTINUATION stream id: " + streamId);
                }
                Http2Stream stream = this.getValidStream(streamId);
                try {
                    this.consumeContinuationFrame(frame, stream);
                }
                catch (H2StreamResetException ex) {
                    stream.localReset(ex);
                }
                catch (HttpStreamResetException ex) {
                    stream.localReset((Exception)ex, ex.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.CANCEL);
                }
                if (!stream.isTerminated()) break;
                this.streamMap.remove(streamId);
                stream.releaseResources();
                break;
            }
            case WINDOW_UPDATE: {
                ByteBuffer payload = frame.getPayload();
                if (payload == null || payload.remaining() != 4) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid WINDOW_UPDATE frame payload");
                }
                int delta = payload.getInt();
                if (delta <= 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Invalid WINDOW_UPDATE delta");
                }
                if (streamId == 0) {
                    try {
                        this.updateOutputWindow(0, this.connOutputWindow, delta);
                    }
                    catch (ArithmeticException ex) {
                        throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, ex.getMessage());
                    }
                }
                Http2Stream stream = this.streamMap.get(streamId);
                if (stream != null) {
                    try {
                        this.updateOutputWindow(streamId, stream.getOutputWindow(), delta);
                    }
                    catch (ArithmeticException ex) {
                        throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, ex.getMessage());
                    }
                }
                this.ioSession.setEvent(4);
                break;
            }
            case RST_STREAM: {
                if (streamId == 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id: " + streamId);
                }
                Http2Stream stream = this.streamMap.get(streamId);
                if (stream == null) {
                    if (streamId <= this.lastStreamId.get()) break;
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected stream id: " + streamId);
                }
                ByteBuffer payload = frame.getPayload();
                if (payload == null || payload.remaining() != 4) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid RST_STREAM frame payload");
                }
                int errorCode = payload.getInt();
                stream.reset(new H2StreamResetException(errorCode, "Stream reset (" + errorCode + ")"));
                this.streamMap.remove(streamId);
                stream.releaseResources();
                break;
            }
            case PING: {
                if (streamId != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id");
                }
                ByteBuffer ping = frame.getPayloadContent();
                if (ping == null || ping.remaining() != 8) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid PING frame payload");
                }
                if (frame.isFlagSet(FrameFlag.ACK)) {
                    AsyncPingHandler pingHandler = this.pingHandlers.poll();
                    if (pingHandler == null) break;
                    pingHandler.consumeResponse(ping);
                    break;
                }
                ByteBuffer pong = ByteBuffer.allocate(ping.remaining());
                pong.put(ping);
                pong.flip();
                RawFrame response = this.frameFactory.createPingAck(pong);
                this.commitFrame(response);
                break;
            }
            case SETTINGS: {
                if (streamId != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id");
                }
                if (frame.isFlagSet(FrameFlag.ACK)) {
                    if (this.localSettingState != SettingsHandshake.TRANSMITTED) break;
                    this.localSettingState = SettingsHandshake.ACKED;
                    this.ioSession.setEvent(4);
                    break;
                }
                ByteBuffer payload = frame.getPayload();
                if (payload != null) {
                    if (payload.remaining() % 6 != 0) {
                        throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid SETTINGS payload");
                    }
                    this.consumeSettingsFrame(payload);
                    this.remoteSettingState = SettingsHandshake.TRANSMITTED;
                }
                RawFrame response = this.frameFactory.createSettingsAck();
                this.commitFrame(response);
                this.remoteSettingState = SettingsHandshake.ACKED;
                break;
            }
            case PRIORITY: {
                break;
            }
            case PUSH_PROMISE: {
                this.acceptPushFrame();
                if (!this.localConfig.isPushEnabled()) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Push is disabled");
                }
                Http2Stream stream = this.getValidStream(streamId);
                if (stream.isRemoteClosed()) {
                    stream.localReset(new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream closed"));
                    break;
                }
                ByteBuffer payload = frame.getPayloadContent();
                if (payload == null || payload.remaining() < 4) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid PUSH_PROMISE payload");
                }
                int promisedStreamId = payload.getInt();
                if (promisedStreamId == 0 || this.idGenerator.isSameSide(promisedStreamId)) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal promised stream id: " + promisedStreamId);
                }
                if (this.streamMap.get(promisedStreamId) != null) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Unexpected promised stream id: " + promisedStreamId);
                }
                this.updateLastStreamId(promisedStreamId);
                Http2StreamChannelImpl channel = new Http2StreamChannelImpl(promisedStreamId, false, this.localConfig.getInitialWindowSize(), this.remoteConfig.getInitialWindowSize());
                Http2StreamHandler streamHandler = this.createRemotelyInitiatedStream(channel, this.httpProcessor, this.connMetrics, stream.getPushHandlerFactory());
                Http2Stream promisedStream = new Http2Stream(channel, streamHandler, true);
                this.streamMap.put(promisedStreamId, promisedStream);
                try {
                    this.consumePushPromiseFrame(frame, payload, promisedStream);
                }
                catch (H2StreamResetException ex) {
                    promisedStream.localReset(ex);
                }
                catch (HttpStreamResetException ex) {
                    stream.localReset((Exception)ex, ex.getCause() != null ? H2Error.INTERNAL_ERROR : H2Error.NO_ERROR);
                }
                break;
            }
            case GOAWAY: {
                if (streamId != 0) {
                    throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Illegal stream id");
                }
                ByteBuffer payload = frame.getPayload();
                if (payload == null || payload.remaining() < 8) {
                    throw new H2ConnectionException(H2Error.FRAME_SIZE_ERROR, "Invalid GOAWAY payload");
                }
                int processedLocalStreamId = payload.getInt();
                int errorCode = payload.getInt();
                if (errorCode == H2Error.NO_ERROR.getCode()) {
                    if (this.connState.compareTo(ConnectionHandshake.ACTIVE) <= 0) {
                        Iterator<Map.Entry<Integer, Http2Stream>> it = this.streamMap.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<Integer, Http2Stream> entry = it.next();
                            int activeStreamId = entry.getKey();
                            if (this.idGenerator.isSameSide(activeStreamId) || activeStreamId <= processedLocalStreamId) continue;
                            Http2Stream stream = entry.getValue();
                            stream.cancel();
                            it.remove();
                        }
                    }
                    this.connState = this.streamMap.isEmpty() ? ConnectionHandshake.SHUTDOWN : ConnectionHandshake.GRACEFUL_SHUTDOWN;
                } else {
                    for (Map.Entry<Integer, Http2Stream> entry : this.streamMap.entrySet()) {
                        Http2Stream stream = entry.getValue();
                        stream.reset(new H2StreamResetException(errorCode, "Connection terminated by the peer (" + errorCode + ")"));
                    }
                    this.streamMap.clear();
                    this.connState = ConnectionHandshake.SHUTDOWN;
                }
                this.ioSession.setEvent(4);
            }
        }
    }

    private void consumeDataFrame(RawFrame frame, Http2Stream stream) throws HttpException, IOException {
        int streamId = stream.getId();
        ByteBuffer payload = frame.getPayloadContent();
        if (payload != null) {
            int chunk;
            int connWinSize;
            int frameLength = frame.getLength();
            int streamWinSize = this.updateInputWindow(streamId, stream.getInputWindow(), -frameLength);
            if (streamWinSize < this.lowMark && !stream.isRemoteClosed()) {
                stream.produceInputCapacityUpdate();
            }
            if ((connWinSize = this.updateInputWindow(0, this.connInputWindow, -frameLength)) < this.lowMark && (chunk = Integer.MAX_VALUE - connWinSize) > 0) {
                RawFrame windowUpdateFrame = this.frameFactory.createWindowUpdate(0, chunk);
                this.commitFrame(windowUpdateFrame);
                this.updateInputWindow(0, this.connInputWindow, chunk);
            }
        }
        if (stream.isRemoteClosed()) {
            throw new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream already closed");
        }
        if (stream.isLocalReset()) {
            return;
        }
        if (frame.isFlagSet(FrameFlag.END_STREAM)) {
            stream.setRemoteEndStream();
        }
        stream.consumeData(payload);
    }

    private void consumePushPromiseFrame(RawFrame frame, ByteBuffer payload, Http2Stream promisedStream) throws HttpException, IOException {
        int promisedStreamId = promisedStream.getId();
        if (!frame.isFlagSet(FrameFlag.END_HEADERS)) {
            this.continuation = new Continuation(promisedStreamId, frame.getType(), true);
        }
        if (this.continuation == null) {
            List<Header> headers = this.hPackDecoder.decodeHeaders(payload);
            if (promisedStreamId > this.processedRemoteStreamId) {
                this.processedRemoteStreamId = promisedStreamId;
            }
            if (this.streamListener != null) {
                this.streamListener.onHeaderInput(this, promisedStreamId, headers);
            }
            if (this.connState == ConnectionHandshake.GRACEFUL_SHUTDOWN) {
                throw new H2StreamResetException(H2Error.REFUSED_STREAM, "Stream refused");
            }
            promisedStream.consumePromise(headers);
        } else {
            this.continuation.copyPayload(payload);
        }
    }

    private void consumeHeaderFrame(RawFrame frame, Http2Stream stream) throws HttpException, IOException {
        int streamId = stream.getId();
        if (!frame.isFlagSet(FrameFlag.END_HEADERS)) {
            this.continuation = new Continuation(streamId, frame.getType(), frame.isFlagSet(FrameFlag.END_STREAM));
        }
        ByteBuffer payload = frame.getPayloadContent();
        if (frame.isFlagSet(FrameFlag.PRIORITY)) {
            payload.getInt();
            payload.get();
        }
        if (this.continuation == null) {
            List<Header> headers = this.hPackDecoder.decodeHeaders(payload);
            if (stream.isRemoteInitiated() && streamId > this.processedRemoteStreamId) {
                this.processedRemoteStreamId = streamId;
            }
            if (this.streamListener != null) {
                this.streamListener.onHeaderInput(this, streamId, headers);
            }
            if (stream.isRemoteClosed()) {
                throw new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream already closed");
            }
            if (stream.isLocalReset()) {
                return;
            }
            if (this.connState == ConnectionHandshake.GRACEFUL_SHUTDOWN) {
                throw new H2StreamResetException(H2Error.PROTOCOL_ERROR, "Stream refused");
            }
            if (frame.isFlagSet(FrameFlag.END_STREAM)) {
                stream.setRemoteEndStream();
            }
            stream.consumeHeader(headers);
        } else {
            this.continuation.copyPayload(payload);
        }
    }

    private void consumeContinuationFrame(RawFrame frame, Http2Stream stream) throws HttpException, IOException {
        int streamId = frame.getStreamId();
        ByteBuffer payload = frame.getPayload();
        this.continuation.copyPayload(payload);
        if (frame.isFlagSet(FrameFlag.END_HEADERS)) {
            List<Header> headers = this.hPackDecoder.decodeHeaders(this.continuation.getContent());
            if (stream.isRemoteInitiated() && streamId > this.processedRemoteStreamId) {
                this.processedRemoteStreamId = streamId;
            }
            if (this.streamListener != null) {
                this.streamListener.onHeaderInput(this, streamId, headers);
            }
            if (this.connState == ConnectionHandshake.GRACEFUL_SHUTDOWN) {
                throw new H2StreamResetException(H2Error.PROTOCOL_ERROR, "Stream refused");
            }
            if (stream.isRemoteClosed()) {
                throw new H2StreamResetException(H2Error.STREAM_CLOSED, "Stream already closed");
            }
            if (stream.isLocalReset()) {
                return;
            }
            if (this.continuation.endStream) {
                stream.setRemoteEndStream();
            }
            if (this.continuation.type == FrameType.PUSH_PROMISE.getValue()) {
                stream.consumePromise(headers);
            } else {
                stream.consumeHeader(headers);
            }
            this.continuation = null;
        }
    }

    private void consumeSettingsFrame(ByteBuffer payload) throws HttpException, IOException {
        H2Config.Builder configBuilder = H2Config.custom();
        block18: while (payload.hasRemaining()) {
            short code = payload.getShort();
            H2Param param = H2Param.valueOf(code);
            if (param == null) continue;
            int value = payload.getInt();
            switch (param) {
                case HEADER_TABLE_SIZE: {
                    configBuilder.setHeaderTableSize(value);
                    this.hPackDecoder.setMaxTableSize(value);
                    break;
                }
                case MAX_CONCURRENT_STREAMS: {
                    try {
                        configBuilder.setMaxConcurrentStreams(value);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                    }
                }
                case ENABLE_PUSH: {
                    configBuilder.setPushEnabled(value == 1);
                    break;
                }
                case INITIAL_WINDOW_SIZE: {
                    try {
                        configBuilder.setInitialWindowSize(value);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                    }
                    int delta = value - this.remoteConfig.getInitialWindowSize();
                    if (delta == 0) break;
                    this.updateOutputWindow(0, this.connOutputWindow, delta);
                    if (this.streamMap.isEmpty()) break;
                    for (Map.Entry<Integer, Http2Stream> entry : this.streamMap.entrySet()) {
                        Http2Stream stream = entry.getValue();
                        try {
                            this.updateOutputWindow(stream.getId(), stream.getOutputWindow(), delta);
                        }
                        catch (ArithmeticException ex) {
                            throw new H2ConnectionException(H2Error.FLOW_CONTROL_ERROR, ex.getMessage());
                        }
                    }
                    continue block18;
                }
                case MAX_FRAME_SIZE: {
                    try {
                        configBuilder.setMaxFrameSize(value);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                    }
                }
                case MAX_HEADER_LIST_SIZE: {
                    try {
                        configBuilder.setMaxHeaderListSize(value);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                    }
                }
            }
        }
        this.remoteConfig = configBuilder.build();
        this.lowMark = this.remoteConfig.getInitialWindowSize() / 2;
    }

    private void produceOutput() throws HttpException, IOException {
        Iterator<Map.Entry<Integer, Http2Stream>> it = this.streamMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Http2Stream> entry = it.next();
            Http2Stream stream = entry.getValue();
            if (!stream.isLocalClosed() && stream.getOutputWindow().get() > 0) {
                stream.produceOutput();
            }
            if (stream.isTerminated()) {
                it.remove();
                stream.releaseResources();
            }
            if (this.outputQueue.isEmpty()) continue;
            break;
        }
    }

    @Override
    public void close() throws IOException {
        this.ioSession.enqueue(ShutdownCommand.GRACEFUL, Command.Priority.IMMEDIATE);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }

    @Override
    public boolean isOpen() {
        return this.connState == ConnectionHandshake.ACTIVE;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        if (this.endpointDetails == null) {
            this.endpointDetails = new BasicEndpointDetails(this.ioSession.getRemoteAddress(), this.ioSession.getLocalAddress(), this.connMetrics, this.ioSession.getSocketTimeout());
        }
        return this.endpointDetails;
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    private static class Http2Stream {
        private final Http2StreamChannelImpl channel;
        private final Http2StreamHandler handler;
        private final boolean remoteInitiated;

        private Http2Stream(Http2StreamChannelImpl channel, Http2StreamHandler handler, boolean remoteInitiated) {
            this.channel = channel;
            this.handler = handler;
            this.remoteInitiated = remoteInitiated;
        }

        int getId() {
            return this.channel.getId();
        }

        boolean isRemoteInitiated() {
            return this.remoteInitiated;
        }

        AtomicInteger getOutputWindow() {
            return this.channel.getOutputWindow();
        }

        AtomicInteger getInputWindow() {
            return this.channel.getInputWindow();
        }

        boolean isTerminated() {
            return this.channel.isLocalClosed() && (this.channel.isRemoteClosed() || this.channel.isResetDeadline());
        }

        boolean isRemoteClosed() {
            return this.channel.isRemoteClosed();
        }

        boolean isLocalClosed() {
            return this.channel.isLocalClosed();
        }

        boolean isLocalReset() {
            return this.channel.isLocalReset();
        }

        void setRemoteEndStream() {
            this.channel.setRemoteEndStream();
        }

        void consumePromise(List<Header> headers) throws HttpException, IOException {
            try {
                this.handler.consumePromise(headers);
                this.channel.setLocalEndStream();
            }
            catch (ProtocolException ex) {
                this.localReset((Exception)ex, H2Error.PROTOCOL_ERROR);
            }
        }

        void consumeHeader(List<Header> headers) throws HttpException, IOException {
            try {
                this.handler.consumeHeader(headers, this.channel.isRemoteClosed());
            }
            catch (ProtocolException ex) {
                this.localReset((Exception)ex, H2Error.PROTOCOL_ERROR);
            }
        }

        void consumeData(ByteBuffer src) throws HttpException, IOException {
            try {
                this.handler.consumeData(src, this.channel.isRemoteClosed());
            }
            catch (CharacterCodingException ex) {
                this.localReset((Exception)ex, H2Error.INTERNAL_ERROR);
            }
            catch (ProtocolException ex) {
                this.localReset((Exception)ex, H2Error.PROTOCOL_ERROR);
            }
        }

        boolean isOutputReady() {
            return this.handler.isOutputReady();
        }

        void produceOutput() throws HttpException, IOException {
            try {
                this.handler.produceOutput();
            }
            catch (ProtocolException ex) {
                this.localReset((Exception)ex, H2Error.PROTOCOL_ERROR);
            }
        }

        void produceInputCapacityUpdate() throws IOException {
            this.handler.updateInputCapacity();
        }

        void reset(Exception cause) {
            this.channel.setRemoteEndStream();
            this.channel.setLocalEndStream();
            this.handler.failed(cause);
        }

        void localReset(Exception cause, int code) throws IOException {
            this.channel.localReset(code);
            this.handler.failed(cause);
        }

        void localReset(Exception cause, H2Error error) throws IOException {
            this.localReset(cause, error != null ? error.getCode() : H2Error.INTERNAL_ERROR.getCode());
        }

        void localReset(H2StreamResetException ex) throws IOException {
            this.localReset((Exception)ex, ex.getCode());
        }

        HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
            return this.handler.getPushHandlerFactory();
        }

        void cancel() {
            this.reset(new CancellationException("HTTP/2 message exchange cancelled"));
        }

        boolean abort() {
            boolean cancelled = this.channel.cancel();
            this.handler.failed(new CancellationException("HTTP/2 message exchange cancelled"));
            return cancelled;
        }

        void releaseResources() {
            this.handler.releaseResources();
            this.channel.requestOutput();
        }

        public String toString() {
            return this.channel.toString();
        }
    }

    private class Http2StreamChannelImpl
    implements Http2StreamChannel {
        private final int id;
        private final AtomicInteger inputWindow;
        private final AtomicInteger outputWindow;
        private volatile boolean idle;
        private volatile boolean remoteEndStream;
        private volatile boolean localEndStream;
        private volatile long deadline;

        Http2StreamChannelImpl(int id, boolean idle, int initialInputWindowSize, int initialOutputWindowSize) {
            this.id = id;
            this.idle = idle;
            this.inputWindow = new AtomicInteger(initialInputWindowSize);
            this.outputWindow = new AtomicInteger(initialOutputWindowSize);
        }

        int getId() {
            return this.id;
        }

        AtomicInteger getOutputWindow() {
            return this.outputWindow;
        }

        AtomicInteger getInputWindow() {
            return this.inputWindow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void submit(List<Header> headers, boolean endStream) throws IOException {
            AbstractHttp2StreamMultiplexer.this.outputLock.lock();
            try {
                if (headers == null || headers.isEmpty()) {
                    throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Message headers are missing");
                }
                if (this.localEndStream) {
                    return;
                }
                this.idle = false;
                AbstractHttp2StreamMultiplexer.this.commitHeaders(this.id, headers, endStream);
                if (endStream) {
                    this.localEndStream = true;
                }
            }
            finally {
                AbstractHttp2StreamMultiplexer.this.outputLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(List<Header> headers, AsyncPushProducer pushProducer) throws HttpException, IOException {
            AbstractHttp2StreamMultiplexer.this.acceptPushRequest();
            int promisedStreamId = AbstractHttp2StreamMultiplexer.this.generateStreamId();
            Http2StreamChannelImpl channel = new Http2StreamChannelImpl(promisedStreamId, true, AbstractHttp2StreamMultiplexer.this.localConfig.getInitialWindowSize(), AbstractHttp2StreamMultiplexer.this.remoteConfig.getInitialWindowSize());
            HttpCoreContext context = HttpCoreContext.create();
            context.setAttribute("http.ssl-session", AbstractHttp2StreamMultiplexer.this.getSSLSession());
            context.setAttribute("http.connection-endpoint", AbstractHttp2StreamMultiplexer.this.getEndpointDetails());
            ServerPushHttp2StreamHandler streamHandler = new ServerPushHttp2StreamHandler(channel, AbstractHttp2StreamMultiplexer.this.httpProcessor, AbstractHttp2StreamMultiplexer.this.connMetrics, pushProducer, context);
            Http2Stream stream = new Http2Stream(channel, streamHandler, false);
            AbstractHttp2StreamMultiplexer.this.streamMap.put(promisedStreamId, stream);
            AbstractHttp2StreamMultiplexer.this.outputLock.lock();
            try {
                if (this.localEndStream) {
                    stream.releaseResources();
                    return;
                }
                AbstractHttp2StreamMultiplexer.this.commitPushPromise(this.id, promisedStreamId, headers);
                this.idle = false;
            }
            finally {
                AbstractHttp2StreamMultiplexer.this.outputLock.unlock();
            }
        }

        @Override
        public void update(int increment) throws IOException {
            if (this.remoteEndStream) {
                return;
            }
            AbstractHttp2StreamMultiplexer.this.incrementInputCapacity(this.id, this.inputWindow, increment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer payload) throws IOException {
            AbstractHttp2StreamMultiplexer.this.outputLock.lock();
            try {
                if (this.localEndStream) {
                    int n = 0;
                    return n;
                }
                int n = AbstractHttp2StreamMultiplexer.this.streamData(this.id, this.outputWindow, payload);
                return n;
            }
            finally {
                AbstractHttp2StreamMultiplexer.this.outputLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endStream(List<? extends Header> trailers) throws IOException {
            AbstractHttp2StreamMultiplexer.this.outputLock.lock();
            try {
                if (this.localEndStream) {
                    return;
                }
                this.localEndStream = true;
                if (trailers != null && !trailers.isEmpty()) {
                    AbstractHttp2StreamMultiplexer.this.commitHeaders(this.id, trailers, true);
                } else {
                    RawFrame frame = AbstractHttp2StreamMultiplexer.this.frameFactory.createData(this.id, null, true);
                    AbstractHttp2StreamMultiplexer.this.commitFrameInternal(frame);
                }
            }
            finally {
                AbstractHttp2StreamMultiplexer.this.outputLock.unlock();
            }
        }

        @Override
        public void endStream() throws IOException {
            this.endStream(null);
        }

        @Override
        public void requestOutput() {
            AbstractHttp2StreamMultiplexer.this.requestSessionOutput();
        }

        boolean isRemoteClosed() {
            return this.remoteEndStream;
        }

        void setRemoteEndStream() {
            this.remoteEndStream = true;
        }

        boolean isLocalClosed() {
            return this.localEndStream;
        }

        void setLocalEndStream() {
            this.localEndStream = true;
        }

        boolean isLocalReset() {
            return this.deadline > 0L;
        }

        boolean isResetDeadline() {
            long l = this.deadline;
            return l > 0L && l < System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean localReset(int code) throws IOException {
            AbstractHttp2StreamMultiplexer.this.outputLock.lock();
            try {
                if (this.localEndStream) {
                    boolean bl = false;
                    return bl;
                }
                this.localEndStream = true;
                this.deadline = System.currentTimeMillis() + 1000L;
                if (!this.idle) {
                    RawFrame resetStream = AbstractHttp2StreamMultiplexer.this.frameFactory.createResetStream(this.id, code);
                    AbstractHttp2StreamMultiplexer.this.commitFrameInternal(resetStream);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                AbstractHttp2StreamMultiplexer.this.outputLock.unlock();
            }
        }

        boolean localReset(H2Error error) throws IOException {
            return this.localReset(error != null ? error.getCode() : H2Error.INTERNAL_ERROR.getCode());
        }

        @Override
        public boolean cancel() {
            try {
                return this.localReset(H2Error.CANCEL);
            }
            catch (IOException ignore) {
                return false;
            }
        }

        public String toString() {
            return "[id=" + this.id + ", inputWindow=" + this.inputWindow + ", outputWindow=" + this.outputWindow + ", remoteEndStream=" + this.remoteEndStream + ", localEndStream=" + this.localEndStream + ']';
        }
    }

    private static class Continuation {
        final int streamId;
        final int type;
        final boolean endStream;
        final ByteArrayBuffer headerBuffer;

        private Continuation(int streamId, int type, boolean endStream) {
            this.streamId = streamId;
            this.type = type;
            this.endStream = endStream;
            this.headerBuffer = new ByteArrayBuffer(1024);
        }

        void copyPayload(ByteBuffer payload) {
            if (payload == null) {
                return;
            }
            this.headerBuffer.ensureCapacity(payload.remaining());
            payload.get(this.headerBuffer.array(), this.headerBuffer.length(), payload.remaining());
        }

        ByteBuffer getContent() {
            return ByteBuffer.wrap(this.headerBuffer.array(), 0, this.headerBuffer.length());
        }
    }

    static enum SettingsHandshake {
        READY,
        TRANSMITTED,
        ACKED;

    }

    static enum ConnectionHandshake {
        READY,
        ACTIVE,
        GRACEFUL_SHUTDOWN,
        SHUTDOWN;

    }
}

