/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.StreamChannel;
import org.apache.hc.core5.util.Args;

public abstract class AbstractBinAsyncEntityProducer
implements AsyncEntityProducer {
    private final ByteBuffer bytebuf;
    private final int fragmentSizeHint;
    private final ContentType contentType;
    private volatile boolean endStream;

    public AbstractBinAsyncEntityProducer(int bufferSize, int fragmentSizeHint, ContentType contentType) {
        Args.positive(bufferSize, "Buffer size");
        this.bytebuf = ByteBuffer.allocate(bufferSize);
        this.fragmentSizeHint = fragmentSizeHint >= 0 ? fragmentSizeHint : bufferSize / 2;
        this.contentType = contentType;
    }

    protected abstract void produceData(StreamChannel<ByteBuffer> var1) throws IOException;

    @Override
    public final String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public Set<String> getTrailerNames() {
        return null;
    }

    @Override
    public final void produce(final DataStreamChannel channel) throws IOException {
        this.produceData(new StreamChannel<ByteBuffer>(){

            @Override
            public int write(ByteBuffer src) throws IOException {
                int bytesWritten;
                Args.notNull(src, "Buffer");
                int chunk = src.remaining();
                if (chunk == 0) {
                    return 0;
                }
                if (AbstractBinAsyncEntityProducer.this.bytebuf.remaining() >= chunk) {
                    AbstractBinAsyncEntityProducer.this.bytebuf.put(src);
                    return chunk;
                }
                int totalBytesWritten = 0;
                if (!AbstractBinAsyncEntityProducer.this.bytebuf.hasRemaining() || AbstractBinAsyncEntityProducer.this.bytebuf.position() >= AbstractBinAsyncEntityProducer.this.fragmentSizeHint) {
                    AbstractBinAsyncEntityProducer.this.bytebuf.flip();
                    bytesWritten = channel.write(AbstractBinAsyncEntityProducer.this.bytebuf);
                    AbstractBinAsyncEntityProducer.this.bytebuf.compact();
                    totalBytesWritten += bytesWritten;
                }
                if (AbstractBinAsyncEntityProducer.this.bytebuf.position() == 0) {
                    bytesWritten = channel.write(src);
                    totalBytesWritten += bytesWritten;
                }
                return totalBytesWritten;
            }

            @Override
            public void endStream() throws IOException {
                AbstractBinAsyncEntityProducer.this.endStream = true;
            }
        });
        if (this.endStream || !this.bytebuf.hasRemaining() || this.bytebuf.position() >= this.fragmentSizeHint) {
            this.bytebuf.flip();
            channel.write(this.bytebuf);
            this.bytebuf.compact();
        }
        if (this.bytebuf.position() == 0 && this.endStream) {
            channel.endStream();
        }
    }
}

