/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.util.Args;

public final class ComplexCancellable
implements CancellableDependency {
    private final AtomicReference<Cancellable> dependencyRef = new AtomicReference<Object>(null);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public void setDependency(Cancellable dependency) {
        Args.notNull(dependency, "dependency");
        if (!this.cancelled.get()) {
            this.dependencyRef.set(dependency);
        } else {
            dependency.cancel();
        }
    }

    @Override
    public boolean cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            Cancellable dependency = this.dependencyRef.getAndSet(null);
            if (dependency != null) {
                dependency.cancel();
            }
            return true;
        }
        return false;
    }
}

