/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.util.Iterator;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.testing.classic.LoggingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingHttp1StreamListener
implements Http1StreamListener {
    public static final LoggingHttp1StreamListener INSTANCE_CLIENT = new LoggingHttp1StreamListener(Type.CLIENT);
    public static final LoggingHttp1StreamListener INSTANCE_SERVER = new LoggingHttp1StreamListener(Type.SERVER);
    private final Type type;
    private final Logger connLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.connection");
    private final Logger headerLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.headers");

    private LoggingHttp1StreamListener(Type type) {
        this.type = type;
    }

    private String requestDirection() {
        return this.type == Type.CLIENT ? " >> " : " << ";
    }

    private String responseDirection() {
        return this.type == Type.CLIENT ? " << " : " >> ";
    }

    public void onRequestHead(HttpConnection connection, HttpRequest request) {
        if (this.headerLog.isDebugEnabled()) {
            this.headerLog.debug(LoggingSupport.getId(connection) + this.requestDirection() + new RequestLine(request));
            Iterator it = request.headerIterator();
            while (it.hasNext()) {
                this.headerLog.debug(LoggingSupport.getId(connection) + this.requestDirection() + it.next());
            }
        }
    }

    public void onResponseHead(HttpConnection connection, HttpResponse response) {
        if (this.headerLog.isDebugEnabled()) {
            this.headerLog.debug(LoggingSupport.getId(connection) + this.responseDirection() + new StatusLine(response));
            Iterator it = response.headerIterator();
            while (it.hasNext()) {
                this.headerLog.debug(LoggingSupport.getId(connection) + this.responseDirection() + it.next());
            }
        }
    }

    public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
        if (this.connLog.isDebugEnabled()) {
            if (keepAlive) {
                this.connLog.debug(LoggingSupport.getId(connection) + " Connection is kept alive");
            } else {
                this.connLog.debug(LoggingSupport.getId(connection) + " Connection is not kept alive");
            }
        }
    }

    static enum Type {
        CLIENT,
        SERVER;

    }
}

