/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ClientHttpProtocolNegotiator;
import org.apache.hc.core5.http2.ssl.ApplicationProtocols;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Timeout;

@Internal
public class Http2OnlyClientProtocolNegotiator
implements HttpConnectionEventHandler {
    private final ProtocolIOSession ioSession;
    private final ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final boolean strictALPNHandshake;
    private final ByteBuffer preface;

    public Http2OnlyClientProtocolNegotiator(ProtocolIOSession ioSession, ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory, boolean strictALPNHandshake) {
        this.ioSession = Args.notNull(ioSession, "I/O session");
        this.http2StreamHandlerFactory = Args.notNull(http2StreamHandlerFactory, "HTTP/2 stream handler factory");
        this.strictALPNHandshake = strictALPNHandshake;
        this.preface = ByteBuffer.wrap(ClientHttpProtocolNegotiator.PREFACE);
    }

    @Override
    public void connected(IOSession session) {
        try {
            TlsDetails tlsDetails = this.ioSession.getTlsDetails();
            if (tlsDetails != null) {
                String applicationProtocol = tlsDetails.getApplicationProtocol();
                if (TextUtils.isEmpty(applicationProtocol)) {
                    if (this.strictALPNHandshake) {
                        throw new HttpException("ALPN: missing application protocol");
                    }
                } else if (!ApplicationProtocols.HTTP_2.id.equals(applicationProtocol)) {
                    throw new HttpException("ALPN: unexpected application protocol '" + applicationProtocol + "'");
                }
            }
            this.writePreface(session);
        }
        catch (Exception ex) {
            session.close(CloseMode.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    private void writePreface(IOSession session) throws IOException {
        if (this.preface.hasRemaining()) {
            ByteChannel channel = session.channel();
            channel.write(this.preface);
        }
        if (!this.preface.hasRemaining()) {
            ClientHttp2StreamMultiplexer streamMultiplexer = this.http2StreamHandlerFactory.create(this.ioSession);
            ClientHttp2IOEventHandler newHandler = new ClientHttp2IOEventHandler(streamMultiplexer);
            newHandler.connected(session);
            this.ioSession.upgrade(newHandler);
        }
    }

    @Override
    public void inputReady(IOSession session) {
        this.outputReady(session);
    }

    @Override
    public void outputReady(IOSession session) {
        try {
            if (this.preface != null) {
                this.writePreface(session);
            } else {
                session.close(CloseMode.GRACEFUL);
            }
        }
        catch (IOException ex) {
            session.close(CloseMode.IMMEDIATE);
            this.exception(session, ex);
        }
    }

    @Override
    public void timeout(IOSession session, Timeout timeout) {
        this.exception(session, SocketTimeoutExceptionFactory.create(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(IOSession session, Exception cause) {
        try {
            Command command;
            while ((command = this.ioSession.poll()) != null) {
                if (command instanceof RequestExecutionCommand) {
                    RequestExecutionCommand executionCommand = (RequestExecutionCommand)command;
                    AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                    exchangeHandler.failed(cause);
                    exchangeHandler.releaseResources();
                    continue;
                }
                command.cancel();
            }
        }
        finally {
            session.close(CloseMode.IMMEDIATE);
        }
    }

    @Override
    public void disconnected(IOSession session) {
        Command command;
        while ((command = this.ioSession.poll()) != null) {
            if (command instanceof RequestExecutionCommand) {
                RequestExecutionCommand executionCommand = (RequestExecutionCommand)command;
                AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                exchangeHandler.failed(new ConnectionClosedException());
                exchangeHandler.releaseResources();
                continue;
            }
            command.cancel();
        }
    }

    @Override
    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public EndpointDetails getEndpointDetails() {
        return null;
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return !this.ioSession.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.ioSession.close();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }
}

