/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.util.Args;

public abstract class AbstractImmutableHttpEntity
implements HttpEntity {
    static final int OUTPUT_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        Args.notNull(outStream, "Output stream");
        InputStream inStream = this.getContent();
        if (inStream != null) {
            try {
                int l;
                byte[] tmp = new byte[4096];
                while ((l = inStream.read(tmp)) != -1) {
                    outStream.write(tmp, 0, l);
                }
            }
            finally {
                inStream.close();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append("Content-Type: ");
        sb.append(this.getContentType());
        sb.append(',');
        sb.append("Content-Encoding: ");
        sb.append(this.getContentEncoding());
        sb.append(',');
        long len = this.getContentLength();
        if (len >= 0L) {
            sb.append("Content-Length: ");
            sb.append(len);
            sb.append(',');
        }
        sb.append("Chunked: ");
        sb.append(this.isChunked());
        sb.append(']');
        return sb.toString();
    }
}

