/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactive;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpStreamResetException;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.util.Args;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Contract(threading=ThreadingBehavior.SAFE)
final class ReactiveDataConsumer
implements AsyncDataConsumer,
Publisher<ByteBuffer> {
    static final int MAX_BUFFER = 0x100000;
    private final AtomicLong requests = new AtomicLong(0L);
    private final AtomicInteger remainingBufferSpace = new AtomicInteger(0x100000);
    private final BlockingQueue<ByteBuffer> buffers = new LinkedBlockingQueue<ByteBuffer>();
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final AtomicInteger windowScalingIncrement = new AtomicInteger(0);
    private volatile boolean cancelled = false;
    private volatile boolean completed = false;
    private volatile Exception exception;
    private volatile CapacityChannel capacityChannel;
    private volatile Subscriber<? super ByteBuffer> subscriber;

    ReactiveDataConsumer() {
    }

    public void failed(Exception cause) {
        this.exception = cause;
        this.flushToSubscriber();
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.throwIfCancelled();
        this.capacityChannel = capacityChannel;
    }

    private void throwIfCancelled() throws IOException {
        if (this.cancelled) {
            throw new HttpStreamResetException("Downstream subscriber to ReactiveDataConsumer cancelled");
        }
    }

    public int consume(ByteBuffer byteBuffer) throws IOException {
        if (this.completed) {
            throw new IllegalStateException("Received data past end of stream");
        }
        this.throwIfCancelled();
        byte[] copy = new byte[byteBuffer.remaining()];
        byteBuffer.get(copy);
        this.remainingBufferSpace.addAndGet(-copy.length);
        this.buffers.add(ByteBuffer.wrap(copy));
        this.flushToSubscriber();
        return this.remainingBufferSpace.get();
    }

    public void streamEnd(List<? extends Header> trailers) {
        this.completed = true;
        this.flushToSubscriber();
    }

    public void releaseResources() {
        this.capacityChannel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushToSubscriber() {
        Subscriber<? super ByteBuffer> s = this.subscriber;
        if (this.flushInProgress.getAndSet(true)) {
            return;
        }
        try {
            int increment;
            ByteBuffer next;
            if (s == null) {
                return;
            }
            if (this.exception != null) {
                this.subscriber = null;
                s.onError((Throwable)this.exception);
                return;
            }
            while (this.requests.get() > 0L && (next = (ByteBuffer)this.buffers.poll()) != null) {
                int bytesFreed = next.remaining();
                this.remainingBufferSpace.addAndGet(bytesFreed);
                s.onNext((Object)next);
                this.requests.decrementAndGet();
                this.windowScalingIncrement.addAndGet(bytesFreed);
            }
            if (this.capacityChannel != null && (increment = this.windowScalingIncrement.getAndSet(0)) > 0) {
                try {
                    this.capacityChannel.update(increment);
                }
                catch (IOException ex) {
                    this.failed(ex);
                    this.flushInProgress.set(false);
                    return;
                }
            }
            if (this.completed && this.buffers.isEmpty()) {
                this.subscriber = null;
                s.onComplete();
            }
        }
        finally {
            this.flushInProgress.set(false);
        }
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.subscriber = (Subscriber)Args.notNull(subscriber, (String)"subscriber");
        subscriber.onSubscribe(new Subscription(){

            public void request(long increment) {
                if (increment <= 0L) {
                    ReactiveDataConsumer.this.failed(new IllegalArgumentException("The number of elements requested must be strictly positive"));
                    return;
                }
                ReactiveDataConsumer.this.requests.addAndGet(increment);
                ReactiveDataConsumer.this.flushToSubscriber();
            }

            public void cancel() {
                ReactiveDataConsumer.this.cancelled = true;
                ReactiveDataConsumer.this.subscriber = null;
            }
        });
    }
}

