/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.impl.nio.ServerHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.ServerHttpProtocolNegotiator;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
@Internal
public class ServerHttpProtocolNegotiatorFactory
implements IOEventHandlerFactory {
    private final ServerHttp1StreamDuplexerFactory http1StreamDuplexerFactory;
    private final ServerHttp2StreamMultiplexerFactory http2StreamMultiplexerFactory;
    private final HttpVersionPolicy versionPolicy;
    private final TlsStrategy tlsStrategy;

    public ServerHttpProtocolNegotiatorFactory(ServerHttp1StreamDuplexerFactory http1StreamDuplexerFactory, ServerHttp2StreamMultiplexerFactory http2StreamMultiplexerFactory, HttpVersionPolicy versionPolicy, TlsStrategy tlsStrategy) {
        this.http1StreamDuplexerFactory = (ServerHttp1StreamDuplexerFactory)Args.notNull((Object)http1StreamDuplexerFactory, (String)"HTTP/1.1 stream handler factory");
        this.http2StreamMultiplexerFactory = (ServerHttp2StreamMultiplexerFactory)Args.notNull((Object)http2StreamMultiplexerFactory, (String)"HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.tlsStrategy = tlsStrategy;
    }

    public ServerHttpProtocolNegotiator createHandler(ProtocolIOSession ioSession, Object attachment) {
        if (this.tlsStrategy != null) {
            this.tlsStrategy.upgrade((TransportSecurityLayer)ioSession, null, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), attachment != null ? attachment : this.versionPolicy);
        }
        return new ServerHttpProtocolNegotiator(ioSession, this.http1StreamDuplexerFactory, this.http2StreamMultiplexerFactory, this.versionPolicy);
    }
}

