/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.nio.ClientHttp1IOEventHandler;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexer;
import org.apache.hc.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import org.apache.hc.core5.http.impl.nio.HttpConnectionEventHandler;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2IOEventHandler;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.ssl.ApplicationProtocols;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.SocketTimeoutExceptionFactory;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Timeout;

@Internal
public class ClientHttpProtocolNegotiator
implements HttpConnectionEventHandler {
    static final byte[] PREFACE = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};
    private final ProtocolIOSession ioSession;
    private final ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory;
    private final ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory;
    private final HttpVersionPolicy versionPolicy;
    private volatile ByteBuffer preface;

    public ClientHttpProtocolNegotiator(ProtocolIOSession ioSession, ClientHttp1StreamDuplexerFactory http1StreamHandlerFactory, ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory, HttpVersionPolicy versionPolicy) {
        this.ioSession = (ProtocolIOSession)Args.notNull((Object)ioSession, (String)"I/O session");
        this.http1StreamHandlerFactory = (ClientHttp1StreamDuplexerFactory)Args.notNull((Object)http1StreamHandlerFactory, (String)"HTTP/1.1 stream handler factory");
        this.http2StreamHandlerFactory = (ClientHttp2StreamMultiplexerFactory)Args.notNull((Object)http2StreamHandlerFactory, (String)"HTTP/2 stream handler factory");
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
    }

    private void startHttp1(IOSession session) {
        ClientHttp1StreamDuplexer http1StreamHandler = this.http1StreamHandlerFactory.create(this.ioSession);
        ClientHttp1IOEventHandler newHandler = new ClientHttp1IOEventHandler(http1StreamHandler);
        try {
            this.ioSession.upgrade((IOEventHandler)newHandler);
            newHandler.connected(session);
        }
        catch (Exception ex) {
            newHandler.exception(session, ex);
            session.close(CloseMode.IMMEDIATE);
        }
    }

    private void startHttp2(IOSession session) {
        ClientHttp2StreamMultiplexer streamMultiplexer = this.http2StreamHandlerFactory.create(this.ioSession);
        ClientHttp2IOEventHandler newHandler = new ClientHttp2IOEventHandler(streamMultiplexer);
        try {
            this.ioSession.upgrade((IOEventHandler)newHandler);
            newHandler.connected(session);
        }
        catch (Exception ex) {
            newHandler.exception(session, ex);
            session.close(CloseMode.IMMEDIATE);
        }
    }

    public void connected(IOSession session) throws IOException {
        switch (this.versionPolicy) {
            case NEGOTIATE: {
                TlsDetails tlsDetails = this.ioSession.getTlsDetails();
                if (tlsDetails == null || !ApplicationProtocols.HTTP_2.id.equals(tlsDetails.getApplicationProtocol())) break;
                this.preface = ByteBuffer.wrap(PREFACE);
                break;
            }
            case FORCE_HTTP_2: {
                this.preface = ByteBuffer.wrap(PREFACE);
            }
        }
        if (this.preface == null) {
            this.startHttp1(session);
        } else {
            if (this.preface.hasRemaining()) {
                ByteChannel channel = session.channel();
                channel.write(this.preface);
            }
            if (!this.preface.hasRemaining()) {
                this.startHttp2(session);
            }
        }
    }

    public void inputReady(IOSession session) throws IOException {
        this.outputReady(session);
    }

    public void outputReady(IOSession session) throws IOException {
        if (this.preface != null) {
            if (this.preface.hasRemaining()) {
                ByteChannel channel = session.channel();
                channel.write(this.preface);
            }
            if (!this.preface.hasRemaining()) {
                this.startHttp2(session);
            }
        } else {
            session.close(CloseMode.GRACEFUL);
        }
    }

    public void timeout(IOSession session, Timeout timeout) {
        this.exception(session, SocketTimeoutExceptionFactory.create((Timeout)timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exception(IOSession session, Exception cause) {
        try {
            Command command;
            while ((command = this.ioSession.poll()) != null) {
                if (command instanceof RequestExecutionCommand) {
                    RequestExecutionCommand executionCommand = (RequestExecutionCommand)command;
                    AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                    exchangeHandler.failed(cause);
                    exchangeHandler.releaseResources();
                    continue;
                }
                command.cancel();
            }
        }
        finally {
            session.close(CloseMode.IMMEDIATE);
        }
    }

    public void disconnected(IOSession session) {
        Command command;
        while ((command = this.ioSession.poll()) != null) {
            if (command instanceof RequestExecutionCommand) {
                RequestExecutionCommand executionCommand = (RequestExecutionCommand)command;
                AsyncClientExchangeHandler exchangeHandler = executionCommand.getExchangeHandler();
                exchangeHandler.failed((Exception)new ConnectionClosedException());
                exchangeHandler.releaseResources();
                continue;
            }
            command.cancel();
        }
    }

    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.ioSession.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    public EndpointDetails getEndpointDetails() {
        return null;
    }

    public void setSocketTimeout(Timeout timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    public Timeout getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    public ProtocolVersion getProtocolVersion() {
        return null;
    }

    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    public boolean isOpen() {
        return !this.ioSession.isClosed();
    }

    public void close() throws IOException {
        this.ioSession.close();
    }

    public void close(CloseMode closeMode) {
        this.ioSession.close(closeMode);
    }
}

