/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;

abstract class InternalChannel
implements ModalCloseable {
    InternalChannel() {
    }

    abstract void onIOEvent(int var1) throws IOException;

    abstract void onTimeout(int var1) throws IOException;

    abstract void onException(Exception var1);

    abstract int getTimeoutMillis();

    abstract long getLastReadTimeMillis();

    final void handleIOEvent(int ops) {
        try {
            this.onIOEvent(ops);
        }
        catch (CancelledKeyException ex) {
            this.close(CloseMode.GRACEFUL);
        }
        catch (Exception ex) {
            this.onException(ex);
            this.close(CloseMode.IMMEDIATE);
        }
    }

    final boolean checkTimeout(long currentTimeMillis) {
        long deadlineMillils;
        int timeoutMillis = this.getTimeoutMillis();
        if (timeoutMillis > 0 && currentTimeMillis > (deadlineMillils = this.getLastReadTimeMillis() + (long)timeoutMillis)) {
            try {
                this.onTimeout(timeoutMillis);
            }
            catch (CancelledKeyException ex) {
                this.close(CloseMode.GRACEFUL);
            }
            catch (Exception ex) {
                this.onException(ex);
                this.close(CloseMode.IMMEDIATE);
            }
            return false;
        }
        return true;
    }
}

