/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.net.SocketAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;

class IOSessionImpl
implements IOSession {
    private static final AtomicLong COUNT = new AtomicLong(0L);
    private final SelectionKey key;
    private final SocketChannel channel;
    private final Deque<Command> commandQueue;
    private final Lock lock;
    private final String id;
    private final AtomicInteger status;
    private volatile IOEventHandler eventHandler;
    private volatile int socketTimeout;
    private volatile long lastReadTime;
    private volatile long lastWriteTime;

    public IOSessionImpl(SelectionKey key, SocketChannel socketChannel) {
        this.key = Args.notNull(key, "Selection key");
        this.channel = Args.notNull(socketChannel, "Socket channel");
        this.commandQueue = new ConcurrentLinkedDeque<Command>();
        this.lock = new ReentrantLock();
        this.socketTimeout = 0;
        this.id = String.format("i/o-%08X", COUNT.getAndIncrement());
        this.status = new AtomicInteger(0);
        this.lastReadTime = System.currentTimeMillis();
        this.lastWriteTime = System.currentTimeMillis();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Lock lock() {
        return this.lock;
    }

    @Override
    public void enqueue(Command command, Command.Priority priority) {
        if (priority == Command.Priority.IMMEDIATE) {
            this.commandQueue.addFirst(command);
        } else {
            this.commandQueue.add(command);
        }
        this.setEvent(4);
    }

    @Override
    public boolean hasCommands() {
        return !this.commandQueue.isEmpty();
    }

    @Override
    public Command poll() {
        return this.commandQueue.poll();
    }

    @Override
    public ByteChannel channel() {
        return this.channel;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.socket().getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.socket().getRemoteSocketAddress();
    }

    @Override
    public int getEventMask() {
        return this.key.interestOps();
    }

    @Override
    public void setEventMask(int newValue) {
        if (this.status.get() == Integer.MAX_VALUE) {
            return;
        }
        this.key.interestOps(newValue);
        this.key.selector().wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEvent(int op) {
        if (this.status.get() == Integer.MAX_VALUE) {
            return;
        }
        this.lock.lock();
        try {
            this.key.interestOps(this.key.interestOps() | op);
        }
        finally {
            this.lock.unlock();
        }
        this.key.selector().wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEvent(int op) {
        if (this.status.get() == Integer.MAX_VALUE) {
            return;
        }
        this.lock.lock();
        try {
            this.key.interestOps(this.key.interestOps() & ~op);
        }
        finally {
            this.lock.unlock();
        }
        this.key.selector().wakeup();
    }

    @Override
    public int getSocketTimeoutMillis() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeoutMillis(int timeout) {
        this.socketTimeout = timeout;
    }

    @Override
    public void updateReadTime() {
        this.lastReadTime = System.currentTimeMillis();
    }

    @Override
    public void updateWriteTime() {
        this.lastWriteTime = System.currentTimeMillis();
    }

    @Override
    public long getLastReadTimeMillis() {
        return this.lastReadTime;
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public void close() {
        if (this.status.compareAndSet(0, Integer.MAX_VALUE)) {
            this.key.cancel();
            this.key.attach(null);
            Closer.closeQuietly(this.key.channel());
            if (this.key.selector().isOpen()) {
                this.key.selector().wakeup();
            }
        }
    }

    @Override
    public int getStatus() {
        return this.status.get();
    }

    @Override
    public boolean isClosed() {
        return this.status.get() == Integer.MAX_VALUE || !this.channel.isOpen();
    }

    @Override
    public void close(CloseMode closeMode) {
        this.close();
    }

    private static void formatOps(StringBuilder buffer, int ops) {
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
        if ((ops & 0x10) > 0) {
            buffer.append('a');
        }
        if ((ops & 8) > 0) {
            buffer.append('c');
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.id).append("[");
        switch (this.status.get()) {
            case 0: {
                buffer.append("ACTIVE");
                break;
            }
            case 1: {
                buffer.append("CLOSING");
                break;
            }
            case 0x7FFFFFFF: {
                buffer.append("CLOSED");
            }
        }
        buffer.append("][");
        if (this.key.isValid()) {
            IOSessionImpl.formatOps(buffer, this.key.interestOps());
            buffer.append(":");
            IOSessionImpl.formatOps(buffer, this.key.readyOps());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

